/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferenceDescriptor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IReferencedLayout;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.Geometry;

public abstract class AbstractReferencedLayout
extends AbstractLayout
implements IReferencedLayout,
IReferenceDescriptor {
    private ReferencedLayoutData layoutData = null;
    private boolean calculating = false;
    private Insets referenceDescription = null;
    private Rectangle prefClientArea = null;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Insets ins = container.getInsets();
        return this.getPreferredClientArea(container).getSize().expand(ins.getWidth(), ins.getHeight());
    }

    public Rectangle getPreferredClientArea(IFigure container) {
        ReferencedLayoutData data = this.getLayoutData(container);
        Rectangle clientArea = data.getClientArea();
        if (clientArea != null) {
            return clientArea;
        }
        if (this.prefClientArea == null) {
            this.prefClientArea = data.createInitBounds();
        }
        return this.prefClientArea;
    }

    public Insets getReferenceDescription(IFigure figure) {
        if (this.referenceDescription == null) {
            this.referenceDescription = this.calculateReferenceDescription(figure);
        }
        return this.referenceDescription;
    }

    protected Insets calculateReferenceDescription(IFigure figure) {
        Point reference = this.getLayoutData(figure).getReference();
        Insets description = Geometry.getInsets(reference, this.getPreferredClientArea(figure));
        return description.add(figure.getInsets());
    }

    public void layout(IFigure container) {
        Point offset = container instanceof IReferencedFigure ? ((IReferencedFigure)container).getReference() : container.getBounds().getLocation();
        ReferencedLayoutData layoutData = this.getLayoutData(container);
        for (Object child : container.getChildren()) {
            Rectangle bounds = layoutData.get(child);
            if (bounds == null) continue;
            bounds = bounds.getTranslated(offset);
            this.layoutChild((IFigure)child, bounds, offset);
        }
    }

    protected void layoutChild(IFigure child, Rectangle bounds, Point offset) {
        child.setBounds(bounds);
    }

    public ReferencedLayoutData getLayoutData(IFigure container) {
        if (this.layoutData == null) {
            this.layoutData = this.createLayoutData(container);
            this.calculating = true;
            this.fillLayoutData(container, this.layoutData);
            this.calculating = false;
        }
        return this.layoutData;
    }

    protected ReferencedLayoutData createLayoutData(IFigure container) {
        return new ReferencedLayoutData();
    }

    protected abstract void fillLayoutData(IFigure var1, ReferencedLayoutData var2);

    public void invalidate() {
        super.invalidate();
        if (!this.calculating) {
            this.layoutData = null;
        }
        this.referenceDescription = null;
        this.prefClientArea = null;
    }
}

