/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder.model;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.ui.internal.iconfinder.model.Category;
import org.xmind.ui.internal.iconfinder.model.Container;
import org.xmind.ui.internal.iconfinder.model.Raster;
import org.xmind.ui.internal.iconfinder.model.Style;
import org.xmind.ui.internal.iconfinder.model.Vector;

public class Icon {
    private JSONObject icon;

    public Icon(JSONObject icon) {
        this.icon = icon;
    }

    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        JSONArray categoriesArray = this.icon.optJSONArray("categories");
        int i = 0;
        while (i < categoriesArray.length()) {
            Category category = new Category(categoriesArray.optJSONObject(i));
            categories.add(category);
            ++i;
        }
        return categories;
    }

    public List<Container> getContainers() {
        ArrayList<Container> containers = new ArrayList<Container>();
        JSONArray containersArray = this.icon.optJSONArray("containers");
        int i = 0;
        while (i < containersArray.length()) {
            Container container = new Container(containersArray.optJSONObject(i));
            containers.add(container);
            ++i;
        }
        return containers;
    }

    public int getIconId() {
        return this.icon.optInt("icon_id");
    }

    public boolean isPremium() {
        return this.icon.optBoolean("is_premium");
    }

    public String getPublishedAt() {
        return this.icon.optString("published_at");
    }

    public List<Raster> getRasterSizes() {
        ArrayList<Raster> rasters = new ArrayList<Raster>();
        JSONArray rasterSizesArray = this.icon.optJSONArray("raster_sizes");
        int i = 0;
        while (i < rasterSizesArray.length()) {
            Raster raster = new Raster(rasterSizesArray.optJSONObject(i));
            rasters.add(raster);
            ++i;
        }
        return rasters;
    }

    public List<Style> getStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        JSONArray stylesArray = this.icon.optJSONArray("styles");
        int i = 0;
        while (i < stylesArray.length()) {
            Style style = new Style(stylesArray.optJSONObject(i));
            styles.add(style);
            ++i;
        }
        return styles;
    }

    public List<String> getTages() {
        ArrayList<String> tags = new ArrayList<String>();
        JSONArray tagsArray = this.icon.optJSONArray("tags");
        int i = 0;
        while (i < tagsArray.length()) {
            String tag = tagsArray.optString(i);
            tags.add(tag);
            ++i;
        }
        return tags;
    }

    public String getType() {
        return this.icon.optString("type");
    }

    public List<Vector> getVectorSizes() {
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        JSONArray vectorsArray = this.icon.optJSONArray("vector_sizes");
        int i = 0;
        while (i < vectorsArray.length()) {
            Vector vector = new Vector(vectorsArray.optJSONObject(i));
            vectors.add(vector);
            ++i;
        }
        return vectors;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Icon)) {
            return false;
        }
        return this.getIconId() == ((Icon)obj).getIconId();
    }
}

