/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import java.net.URL;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyToolBarSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final CSSPropertyToolBarSWTHandler INSTANCE = new CSSPropertyToolBarSWTHandler();
    private static final String TOOLBAR_TAG_VIEW_MENU = "ViewMenu";

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof ToolBar)) {
            return;
        }
        ToolBar toolBar = (ToolBar)control;
        if ("xmind-swt-tool-item-color".equals(property)) {
            ToolItem[] items;
            Color color = (Color)engine.convert(value, Color.class, (Object)toolBar.getDisplay());
            toolBar.setForeground(color);
            ToolItem[] toolItemArray = items = toolBar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem each = toolItemArray[n2];
                String text = each.getText();
                each.setText(text);
                ++n2;
            }
        } else if ("xmind-swt-view-menu-image".equals(property) && value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 20) {
            String imageUrl = ((CSSPrimitiveValue)value).getStringValue();
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(imageUrl.toString()));
            Image image = JFaceResources.getResources().createImage(imageDescriptor);
            if (TOOLBAR_TAG_VIEW_MENU.equals(toolBar.getData())) {
                toolBar.getItem(0).setImage(image);
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        if (control instanceof ToolBar && "xmind-swt-tool-item-color".equals(property)) {
            Color fgColor = ((ToolBar)control).getForeground();
            return engine.convert((Object)fgColor, Color.class, null);
        }
        return null;
    }
}

