/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.resourcemanager.MarkerResourceManagerViewer;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.mindmap.MindMapUI;

public class MarkerResourceManagerPage
extends ResourceManagerDialogPage
implements ICoreEventListener {
    private static final int ADD_GROUP_BUTTON_ID = 1025;
    private CoreEventRegister coreEventRegister;
    private MarkerResourceManagerViewer viewer;
    static final String USER_MARKER_PATH = "markers/markerSheet.xml";

    @Override
    protected ResourceManagerViewer createViewer() {
        this.viewer = new MarkerResourceManagerViewer();
        this.registerCoreEvent();
        return this.viewer;
    }

    private void registerCoreEvent() {
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserMarkerSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
            this.coreEventRegister.setNextSupport(ces);
            this.coreEventRegister.register("markerAdd");
            this.coreEventRegister.register("markerGroupAdd");
            this.coreEventRegister.register("markerRefAdd");
            this.coreEventRegister.register("titleText");
            this.coreEventRegister.register("markerRemove");
            this.coreEventRegister.register("markerGroupRemove");
            this.coreEventRegister.register("markerRefRemove");
            this.coreEventRegister.register("name");
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite buttonBar) {
        Button button = this.createButton(buttonBar, 1025, MindMapMessages.MarkerResourceManagerPage_AddGroup, false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UserAddGroupCount");
                IMarkerSheet markerSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
                IMarkerGroup group = MindMapUI.getResourceManager().getUserMarkerSheet().createMarkerGroup(true);
                group.setName(MindMapMessages.MarkerResourceManagerPage_UserGroup);
                markerSheet.addMarkerGroup(group);
                try {
                    MindMapUI.getResourceManager().saveUserMarkerSheet();
                }
                catch (Exception exception) {}
                MarkerResourceManagerPage.this.viewer.updateInput();
                MarkerResourceManagerPage.this.viewer.activateGroup(group);
                MarkerResourceManagerPage.this.viewer.reveal(group);
                MarkerResourceManagerPage.this.viewer.renameMarkerGroup();
            }
        });
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MarkerResourceManagerPage.this.viewer.refresh();
                MarkerResourceManagerPage.this.viewer.setSelection((ISelection)new StructuredSelection(event.getSource()), true);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.coreEventRegister != null) {
            this.coreEventRegister.unregisterAll();
        }
        super.dispose();
    }

    @Override
    protected void registerRunnable(IEclipseContext eclipseContext) {
        super.registerRunnable(eclipseContext);
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                if (MarkerResourceManagerPage.this.viewer != null && MarkerResourceManagerPage.this.viewer.getControl() != null && !MarkerResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    List markers;
                    if (MarkerResourceManagerPage.this.viewer.canEditMarkerGroup()) {
                        MarkerResourceManagerPage.this.viewer.deleteMarkerGroup();
                    }
                    if (!(markers = MarkerResourceManagerPage.this.getSelectedMarker()).isEmpty()) {
                        ResourceUtils.deleteMarkers(markers);
                    }
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                if (MarkerResourceManagerPage.this.viewer != null && MarkerResourceManagerPage.this.viewer.getControl() != null && !MarkerResourceManagerPage.this.viewer.getControl().isDisposed() && MarkerResourceManagerPage.this.viewer.canEditMarkerGroup()) {
                    return true;
                }
                List markers = MarkerResourceManagerPage.this.getSelectedMarker();
                boolean canExecute = !markers.isEmpty();
                IMarkerSheet userMarkerSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
                for (IMarker marker : markers) {
                    boolean bl = canExecute = canExecute && userMarkerSheet.getMarker(marker.getId()) != null;
                }
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                if (MarkerResourceManagerPage.this.viewer != null && MarkerResourceManagerPage.this.viewer.getControl() != null && !MarkerResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    MarkerResourceManagerPage.this.viewer.renameMarkerGroup();
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                if (MarkerResourceManagerPage.this.viewer != null && MarkerResourceManagerPage.this.viewer.getControl() != null && !MarkerResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    return MarkerResourceManagerPage.this.viewer.canEditMarkerGroup();
                }
                return false;
            }
        });
    }

    private List<IMarker> getSelectedMarker() {
        IStructuredSelection selection;
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (selection = this.viewer.getStructuredSelection()) instanceof IStructuredSelection) {
            for (Object element : selection.toList()) {
                markers.add((IMarker)element);
            }
        }
        return markers;
    }

    @Override
    protected String getContextMenuId() {
        return "org.xmind.ui.dialogPart.resourceManager.marker.popupMenu";
    }

    public String getModelPageId() {
        return "org.xmind.ui.dialogPart.resourceManager.marker";
    }

    public String getModelPageTitle() {
        return null;
    }
}

