/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.notes.HtmlNotesContentBuilder;
import org.xmind.ui.internal.notes.RichDocumentBuilder;
import org.xmind.ui.resources.ImageUtils;
import org.xmind.ui.richtext.IRichDocument;

public class RichDocumentNotesAdapter
implements IAdaptable {
    private IWorkbook workbook;
    private IRichDocument document;
    private INotesContent content;
    private Map<String, Image> images = null;

    public RichDocumentNotesAdapter(ITopic topic) {
        this.workbook = topic.getOwnedWorkbook();
        INotes notes = topic.getNotes();
        INotesContent content = notes.getContent("html");
        boolean showHTMLContent = false;
        if (content instanceof IHtmlNotesContent) {
            boolean bl = showHTMLContent = !((IHtmlNotesContent)content).getParagraphs().isEmpty();
        }
        if (!showHTMLContent) {
            content = notes.getContent("plain");
        }
        this.content = content;
    }

    public RichDocumentNotesAdapter(IWorkbook workbook, INotesContent content) {
        this.workbook = workbook;
        this.content = content;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRichDocument.class) {
            return this.getDocument();
        }
        return null;
    }

    public IWorkbook getWorkbook() {
        return this.workbook;
    }

    public INotesContent getInitContent() {
        return this.content;
    }

    public IRichDocument getDocument() {
        if (this.document == null) {
            this.document = this.buildDocument();
        }
        return this.document;
    }

    public String getImageUrl(Image image) {
        if (image != null && this.images != null) {
            for (Map.Entry<String, Image> en : this.images.entrySet()) {
                if (en.getValue() != image) continue;
                return HyperlinkUtils.toAttachmentURL((String)en.getKey());
            }
        }
        return null;
    }

    public Image getImageFromUrl(String uri) {
        if (HyperlinkUtils.isFileUrl((String)uri)) {
            return this.getImageFromFilePath(HyperlinkUtils.trimFileUrlContent((String)uri));
        }
        return this.getImageFromEntryPath(HyperlinkUtils.toAttachmentPath((String)uri));
    }

    public Image getImageFromFilePath(String path) {
        Image image = this.getRegisteredImage(path);
        if (image == null) {
            image = new Image((Device)Display.getDefault(), path);
            ImageData data = image.getImageData();
            if (data.width > 280) {
                image = ImageUtils.createScaledImage((Image)image, (int)280, (int)(data.height * 280 / data.width));
            }
            this.registerImage(path, image);
        }
        return image;
    }

    private Image getImageFromEntryPath(String path) {
        IFileEntry entry;
        Image image = this.getRegisteredImage(path);
        if (image == null && (entry = this.workbook.getManifest().getFileEntry(path)) != null) {
            image = AttachmentImageDescriptor.createFromEntry(this.workbook, entry).createImage(false);
            ImageData data = image.getImageData();
            if (data.width > 280) {
                image = ImageUtils.createScaledImage((Image)image, (int)280, (int)(data.height * 280 / data.width));
            }
            this.registerImage(path, image);
        }
        return image;
    }

    private void registerImage(String path, Image image) {
        if (image != null) {
            if (this.images == null) {
                this.images = new HashMap<String, Image>();
            }
            this.images.put(path, image);
        }
    }

    private Image getRegisteredImage(String path) {
        Image image;
        if (this.images != null && (image = this.images.get(path)) != null) {
            return image;
        }
        return null;
    }

    public Image createImageFromFile(String absolutePath) {
        IFileEntry entry = this.createFileEntry(absolutePath);
        if (entry != null) {
            return this.getImageFromEntryPath(entry.getPath());
        }
        return null;
    }

    private IFileEntry createFileEntry(final String absolutePath) {
        final IFileEntry[] entryRef = new IFileEntry[1];
        String message = NLS.bind((String)DialogMessages.ConfirmOverwrite_message, (Object)absolutePath);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(message){

            public void run() throws Exception {
                entryRef[0] = RichDocumentNotesAdapter.this.workbook.getManifest().createAttachmentFromFilePath(absolutePath);
            }
        });
        return entryRef[0];
    }

    public void dispose() {
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images = null;
        }
    }

    private IRichDocument buildDocument() {
        RichDocumentBuilder builder = new RichDocumentBuilder(this);
        builder.build(this.content);
        return builder.getResult();
    }

    public INotesContent makeNewHtmlContent() {
        HtmlNotesContentBuilder builder = new HtmlNotesContentBuilder(this);
        IRichDocument doc = this.getDocument();
        builder.build(doc);
        return builder.getResult();
    }

    public INotesContent makeNewPlainContent() {
        String string = this.getDocument().get();
        if ("".equals(string)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(string);
        int index = 0;
        while ((index = sb.indexOf("\ufffc", index)) >= 0) {
            sb.deleteCharAt(index);
        }
        IPlainNotesContent content = (IPlainNotesContent)this.getWorkbook().createNotesContent("plain");
        content.setTextContent(sb.toString());
        return content;
    }
}

