/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.ISaveContext;

public class SaveWorkbookAsHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Object selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            selection = ((IStructuredSelection)selection).getFirstElement();
        }
        if (!(selection instanceof IWorkbookRef)) {
            return null;
        }
        final String preferredWizardId = event.getParameter("org.xmind.ui.command.saveWorkbookAs.wizardId");
        final Set<String> excludedWizardIds = SaveWorkbookAsHandler.getExcludedWizardIds(event);
        final IWorkbookRef oldWorkbookRef = (IWorkbookRef)selection;
        final IWorkbookRef[] result = new IWorkbookRef[1];
        final ProgressMonitorDialog jobRunner = new ProgressMonitorDialog(window.getShell());
        jobRunner.setOpenOnRun(false);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                result[0] = org.xmind.ui.internal.e4handlers.SaveWorkbookAsHandler.saveWorkbookAs(new ISaveContext(){

                    @Override
                    public Object getContextVariable(String key) {
                        Object variable = HandlerUtil.getVariable((ExecutionEvent)event, (String)key);
                        return variable == IEvaluationContext.UNDEFINED_VARIABLE ? null : variable;
                    }

                    @Override
                    public <T> T getContextVariable(Class<T> key) {
                        return (T)window.getService(key);
                    }
                }, oldWorkbookRef, (IRunnableContext)jobRunner, new IFilter(){

                    public boolean select(Object wizardId) {
                        if (preferredWizardId != null) {
                            return preferredWizardId.equals(wizardId);
                        }
                        if (!excludedWizardIds.isEmpty()) {
                            return !excludedWizardIds.contains(wizardId);
                        }
                        return true;
                    }
                }, false);
            }
        });
        IWorkbookRef newWorkbookRef = result[0];
        if (newWorkbookRef == null || newWorkbookRef.equals(oldWorkbookRef)) {
            return null;
        }
        MessageDialog dialog = new MessageDialog(window.getShell(), MindMapMessages.SaveWorkbookAsHandler_doneDialog_title, null, MindMapMessages.SaveWorkbookAsHandler_doneDialog_message, 5, new String[]{MindMapMessages.SaveWorkbookAsHandler_doneDialog_okButton_text, MindMapMessages.SaveWorkbookAsHandler_doneDialog_cancelButton_text}, 0);
        if (dialog.open() != 0) {
            return null;
        }
        try {
            window.getActivePage().openEditor(MindMapUI.getEditorInputFactory().createEditorInput(newWorkbookRef), "org.xmind.ui.MindMapEditor", true);
        }
        catch (PartInitException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Set<String> getExcludedWizardIds(ExecutionEvent event) {
        HashSet<String> set = new HashSet<String>();
        String param = event.getParameter("org.xmind.ui.command.saveWorkbookAs.excludedWizardIds");
        if (param != null) {
            set.addAll(Arrays.asList(param.split(",")));
        }
        return set;
    }
}

