/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.core.Core;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dnd.MindMapElementTransfer;
import org.xmind.ui.internal.e4models.ViewModelPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MarkerPart
extends ViewModelPart {
    private static final String VIEWMENU_ID_FOR_MARKERPART = "org.xmind.ui.modelpart.marker.viewmenu";
    private WidgetFactory factory;
    private ScrolledForm form;
    private MarkerGroupPart recentPart;
    private MarkerSheetPart systemPart;
    private MarkerSheetPart userPart;
    private Map<IMarkerGroup, MarkerGroupPart> groupToPart = new HashMap<IMarkerGroup, MarkerGroupPart>();
    private Map<IMarkerGroup, Section> groupToSection = new HashMap<IMarkerGroup, Section>();

    protected Control doCreateContent(Composite parent) {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowMarkerPartCount");
        this.factory = new WidgetFactory(parent.getDisplay());
        this.form = this.createForm(parent);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MarkerPart.this.factory != null) {
                    MarkerPart.this.factory.dispose();
                    MarkerPart.this.factory = null;
                }
            }
        });
        this.fillFormContent();
        return this.form;
    }

    protected void init() {
        super.init();
        this.registerViewMenu(VIEWMENU_ID_FOR_MARKERPART);
    }

    private ScrolledForm createForm(Composite parent) {
        ScrolledForm form = this.factory.createScrolledForm(parent);
        form.setMinWidth(1);
        return form;
    }

    private void fillFormContent() {
        final Composite compositeformbady = this.form.getBody();
        final GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 7;
        compositeformbady.setLayout((Layout)layout);
        compositeformbady.setLayoutData((Object)new GridData(4, 4, true, true));
        Control control = this.createRecentSection(compositeformbady);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        control = this.createSystemSection(compositeformbady);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        control = this.createUserSection(compositeformbady);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        this.form.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = ((MarkerPart)MarkerPart.this).form.getClientArea().width;
                width -= layout.marginLeft + layout.marginRight + layout.marginWidth * 2;
                Control[] controls = compositeformbady.getChildren();
                int i = 0;
                while (i < controls.length) {
                    Control c = controls[i];
                    ((GridData)c.getLayoutData()).widthHint = width;
                    ++i;
                }
                MarkerPart.this.form.reflow(true);
            }
        });
        this.form.reflow(true);
    }

    private Control createRecentSection(Composite composite) {
        this.recentPart = new MarkerGroupPart(MindMapUI.getResourceManager().getRecentMarkerGroup(), false);
        Control con = this.recentPart.createControl(composite);
        return con;
    }

    private Control createSystemSection(Composite composite) {
        this.systemPart = new MarkerSheetPart(MindMapUI.getResourceManager().getSystemMarkerSheet());
        Control con = this.systemPart.createControl(composite);
        return con;
    }

    private Control createUserSection(Composite composite) {
        this.userPart = new MarkerSheetPart(MindMapUI.getResourceManager().getUserMarkerSheet());
        Control con = this.userPart.createControl(composite);
        return con;
    }

    private Section createSection(Composite parent, String title, WidgetFactory factory) {
        Section section = factory.createSection(parent, 18754);
        section.setText(title);
        return section;
    }

    protected void setFocus() {
        super.setFocus();
        if (this.form != null && !this.form.isDisposed()) {
            this.form.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.factory = null;
        this.form = null;
        this.recentPart = null;
        this.systemPart = null;
        this.userPart = null;
        this.groupToPart.clear();
        this.groupToSection.clear();
    }

    protected class MarkerAction
    extends Action {
        private IMarker marker;

        public MarkerAction(IMarker marker) {
            this.marker = marker;
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(marker, 24, 24, false));
            this.setToolTipText(marker.getName());
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public void run() {
            IGraphicalEditorPage gp;
            IEditorPart editor;
            IWorkbenchPage page = ((IWorkbenchWindow)MarkerPart.this.getAdapter(IWorkbenchWindow.class)).getActivePage();
            if (page != null && (editor = page.getActiveEditor()) != null && editor instanceof IGraphicalEditor && (gp = ((IGraphicalEditor)editor).getActivePageInstance()) != null) {
                Control control;
                IGraphicalViewer viewer;
                EditDomain domain = gp.getEditDomain();
                if (domain != null) {
                    Request req = new Request("add_marker").setViewer((IViewer)gp.getViewer()).setDomain(domain).setParameter("markerId", (Object)this.marker.getId());
                    domain.handleRequest(req);
                }
                if ((viewer = gp.getViewer()) != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
                    control.setFocus();
                }
            }
        }
    }

    protected class MarkerGroupPart
    implements ICoreEventListener {
        private IMarkerGroup group;
        private Section section;
        private boolean hasTitle;
        private ToolBarManager toolbar = null;
        private Control control = null;
        private ICoreEventRegister eventRegister = null;

        public MarkerGroupPart(IMarkerGroup group) {
            this(group, true);
        }

        public MarkerGroupPart(IMarkerGroup group, boolean hasTitle) {
            this.group = group;
            this.hasTitle = hasTitle;
        }

        public IMarkerGroup getMarkerGroup() {
            return this.group;
        }

        public Control createControl(Composite parent) {
            if (this.control == null) {
                this.section = MarkerPart.this.createSection(parent, this.group.getName(), MarkerPart.this.factory);
                if (this.toolbar == null) {
                    this.toolbar = new ToolBarManager(8519744);
                }
                Composite c = MarkerPart.this.factory.createComposite((Composite)this.section, 64);
                GridLayout layout = new GridLayout(1, true);
                layout.marginHeight = 2;
                layout.marginWidth = 2;
                layout.verticalSpacing = 2;
                layout.marginLeft = Util.isMac() ? 17 : 7;
                c.setLayout((Layout)layout);
                if (this.hasTitle) {
                    MarkerPart.this.factory.createLabel(c, this.group.getName());
                }
                ToolBar tb = this.toolbar.createControl(c);
                GridData data = new GridData(4, 4, true, false);
                tb.setLayoutData((Object)data);
                this.addDragSource(tb);
                this.addDropTarget(tb);
                this.control = this.section;
                this.section.setClient((Control)c);
                this.refresh(false);
                this.installListeners();
                this.control.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerGroupPart.this.dispose();
                    }
                });
            }
            return this.control;
        }

        private void addDragSource(final ToolBar toolbar) {
            final DragSource dragSource = new DragSource((Control)toolbar, 1);
            dragSource.setTransfer(new Transfer[]{MindMapElementTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){
                ToolItem sourceItem;

                public void dragStart(DragSourceEvent event) {
                    this.sourceItem = toolbar.getItem(new Point(event.x, event.y));
                    if (this.sourceItem == null) {
                        event.doit = false;
                    } else {
                        event.image = this.sourceItem.getImage();
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    IMarker marker2;
                    if (this.sourceItem == null) {
                        return;
                    }
                    int index = toolbar.indexOf(this.sourceItem);
                    ArrayList<IMarker> visibleMarkers = new ArrayList<IMarker>();
                    for (IMarker marker2 : MarkerGroupPart.this.group.getMarkers()) {
                        if (marker2.isHidden()) continue;
                        visibleMarkers.add(marker2);
                    }
                    marker2 = (IMarker)visibleMarkers.get(index);
                    event.data = new Object[]{marker2};
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
            toolbar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dragSource.dispose();
                }
            });
        }

        private void addDropTarget(ToolBar toolBar) {
            final DropTarget dropTarget = new DropTarget((Control)toolBar, 3);
            dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
            toolBar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dropTarget.dispose();
                }
            });
            dropTarget.addDropListener(new DropTargetListener(){
                private Map<String, List<String>> dirToMarkerPaths = new HashMap<String, List<String>>();

                public void dropAccept(DropTargetEvent event) {
                    if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                        event.detail = 0;
                    } else if (event.detail == 16) {
                        if ((event.operations & 1) != 0) {
                            event.detail = 1;
                        } else if ((event.operations & 2) != 0) {
                            event.detail = 2;
                        }
                    }
                }

                public void drop(DropTargetEvent event) {
                    if (event.data instanceof String[]) {
                        IMarkerSheet userMarkerSheet = MindMapUI.getResourceManager().getUserMarkerSheet();
                        IMarkerSheet markerSheet = MarkerGroupPart.this.group.getParent();
                        String[] stringArray = (String[])event.data;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String path = stringArray[n2];
                            File dir = new File(path);
                            if (dir.isDirectory()) {
                                this.collectDirToMarkers(path, this.dirToMarkerPaths);
                                Set<String> folders = this.dirToMarkerPaths.keySet();
                                for (String folder : folders) {
                                    List<String> markerPaths;
                                    File tempDir = new File(folder);
                                    if (!tempDir.isDirectory() || (markerPaths = this.dirToMarkerPaths.get(folder)) == null || markerPaths.isEmpty()) continue;
                                    IMarkerGroup markerGroup = userMarkerSheet.createMarkerGroup(false);
                                    markerGroup.setName(tempDir.getName());
                                    userMarkerSheet.addMarkerGroup(markerGroup);
                                    for (String markerPath : markerPaths) {
                                        if (!this.imageValid(markerPath)) continue;
                                        this.createMarker(markerGroup, markerPath);
                                    }
                                }
                            } else if (dir.isFile() && this.imageValid(path)) {
                                if (markerSheet == MindMapUI.getResourceManager().getSystemMarkerSheet()) {
                                    IMarkerGroup markerGroup = userMarkerSheet.createMarkerGroup(false);
                                    markerGroup.setName(MindMapMessages.MarkerView_UntitledGroup_name);
                                    userMarkerSheet.addMarkerGroup(markerGroup);
                                    this.createMarker(markerGroup, path);
                                } else if (userMarkerSheet == markerSheet) {
                                    this.createMarker(MarkerGroupPart.this.group, path);
                                }
                            }
                            ++n2;
                        }
                        MindMapUI.getResourceManager().saveUserMarkerSheet();
                    }
                }

                private void collectDirToMarkers(String dirPath, Map<String, List<String>> dirToMarkerPaths) {
                    File directory = new File(dirPath);
                    if (directory.isDirectory()) {
                        File[] files;
                        List<String> markerPaths = dirToMarkerPaths.get(dirPath);
                        if (markerPaths == null) {
                            markerPaths = new LinkedList<String>();
                        }
                        dirToMarkerPaths.put(dirPath, markerPaths);
                        File[] fileArray = files = directory.listFiles();
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            if (file.isDirectory()) {
                                this.collectDirToMarkers(file.getAbsolutePath(), dirToMarkerPaths);
                            } else if (file.isFile() && this.imageValid(file.getAbsolutePath())) {
                                markerPaths.add(file.getAbsolutePath());
                            }
                            ++n2;
                        }
                    }
                }

                private void createMarker(IMarkerGroup targetGroup, String sourcePath) {
                    OutputStream os;
                    String path = String.valueOf(Core.getIdFactory().createId()) + FileUtils.getExtension((String)sourcePath);
                    IMarker marker = targetGroup.getOwnedSheet().createMarker(path);
                    marker.setName(FileUtils.getFileName((String)sourcePath));
                    IMarkerResource resource = marker.getResource();
                    if (resource != null && (os = resource.getOutputStream()) != null) {
                        try {
                            FileInputStream is = new FileInputStream(sourcePath);
                            FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                        }
                        catch (IOException e) {
                            Logger.log(e);
                        }
                    }
                    targetGroup.addMarker(marker);
                }

                private boolean imageValid(String sourcePath) {
                    try {
                        new Image((Device)Display.getCurrent(), sourcePath).dispose();
                        return true;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }

                public void dragOver(DropTargetEvent event) {
                    this.dropAccept(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    this.dropAccept(event);
                }

                public void dragLeave(DropTargetEvent event) {
                    this.dropAccept(event);
                }

                public void dragEnter(DropTargetEvent event) {
                    this.dropAccept(event);
                }
            });
        }

        private void installListeners() {
            this.eventRegister = new CoreEventRegister((Object)this.group, (ICoreEventListener)this);
            this.eventRegister.register("markerAdd");
            this.eventRegister.register("markerRemove");
            this.eventRegister.register("name");
        }

        private void uninstallListeners() {
            if (this.eventRegister != null) {
                this.eventRegister.unregisterAll();
            }
        }

        public Control getControl() {
            return this.control;
        }

        public void refresh(boolean reflow) {
            if (this.toolbar == null || this.control == null || this.control.isDisposed()) {
                return;
            }
            this.section.setText(this.group.getName());
            this.toolbar.removeAll();
            for (IMarker marker : this.group.getMarkers()) {
                if (this.group.isHidden() || marker.isHidden()) continue;
                this.toolbar.add((IAction)new MarkerAction(marker));
            }
            this.toolbar.update(false);
            ToolBar tb = this.toolbar.getControl();
            GridData data = (GridData)tb.getLayoutData();
            data.exclude = this.toolbar.isEmpty();
            tb.setVisible(!this.toolbar.isEmpty());
            if (reflow) {
                MarkerPart.this.form.reflow(true);
            }
        }

        public void dispose() {
            this.uninstallListeners();
            if (this.toolbar != null) {
                this.toolbar.dispose();
                this.toolbar = null;
            }
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
        }

        public void handleCoreEvent(final CoreEvent event) {
            if (this.control == null || this.control.isDisposed()) {
                return;
            }
            this.control.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String type = event.getType();
                    if ("markerAdd".equals(type) || "markerRemove".equals(type) || "name".equals(type)) {
                        MarkerGroupPart.this.refresh(true);
                    }
                }
            });
        }
    }

    protected class MarkerSheetPart
    implements ICoreEventListener {
        private IMarkerSheet sheet;
        private Composite composite;
        private List<MarkerGroupPart> groupParts = new ArrayList<MarkerGroupPart>();
        private List<Section> groupSections = new ArrayList<Section>();
        private ICoreEventRegister eventRegister = null;

        public MarkerSheetPart(IMarkerSheet sheet) {
            this.sheet = sheet;
        }

        public Control getControl() {
            return this.composite;
        }

        public Control createControl(Composite parent) {
            if (this.composite == null) {
                this.composite = this.createComposite(parent);
                this.refresh(false);
                this.installListeners();
                this.composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MarkerSheetPart.this.dispose();
                    }
                });
            }
            return this.composite;
        }

        private Composite createComposite(Composite parent) {
            Composite composite = MarkerPart.this.factory.createComposite(parent, 64);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.verticalSpacing = 7;
            composite.setLayout((Layout)layout);
            return composite;
        }

        public void refresh(boolean reflow) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            this.composite.setRedraw(false);
            List newGroups = this.sheet.getMarkerGroups();
            int i = 0;
            while (i < newGroups.size()) {
                MarkerGroupPart part;
                IMarkerGroup g;
                IMarkerGroup group = (IMarkerGroup)newGroups.get(i);
                if (i >= this.groupParts.size() || !group.equals(g = (part = this.groupParts.get(i)).getMarkerGroup())) {
                    part = (MarkerGroupPart)MarkerPart.this.groupToPart.get(group);
                    if (part != null) {
                        if (!((IMarkerGroup)newGroups.get(i)).isHidden()) {
                            this.reorderChild(part, i);
                        }
                    } else if (!((IMarkerGroup)newGroups.get(i)).isHidden()) {
                        part = this.createChild(group);
                        this.addChild(part, i);
                    }
                }
                ++i;
            }
            Object[] toTrim = this.groupParts.toArray();
            while (i < toTrim.length) {
                this.removeChild((MarkerGroupPart)toTrim[i]);
                ++i;
            }
            this.composite.setRedraw(true);
            if (reflow) {
                MarkerPart.this.form.reflow(true);
            }
        }

        public List<MarkerGroupPart> getGroupParts() {
            return this.groupParts;
        }

        private void reorderChild(MarkerGroupPart part, int index) {
            Control c = part.getControl();
            if (c == null) {
                c = part.createControl(this.composite);
            }
            this.groupParts.remove(part);
            this.groupParts.add(index, part);
            this.groupSections.remove(part.section);
            this.groupSections.add(index, part.section);
            if (index == 0) {
                c.moveAbove(null);
            } else {
                MarkerGroupPart g = this.groupParts.get(index - 1);
                c.moveAbove(g.getControl());
            }
        }

        private MarkerGroupPart createChild(IMarkerGroup group) {
            MarkerGroupPart part = new MarkerGroupPart(group, false);
            MarkerPart.this.groupToPart.put(group, part);
            return part;
        }

        private void addChild(MarkerGroupPart part, int index) {
            this.groupParts.add(index, part);
            Control c = part.createControl(this.composite);
            this.groupSections.add(index, part.section);
            MarkerPart.this.groupToSection.put(part.group, part.section);
            c.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        private void removeChild(MarkerGroupPart part) {
            this.groupParts.remove(part);
            MarkerPart.this.groupToPart.remove(part.getMarkerGroup());
            this.groupSections.remove(part.section);
            MarkerPart.this.groupToSection.remove(part.getMarkerGroup());
            part.section.dispose();
            part.dispose();
        }

        private void installListeners() {
            this.eventRegister = new CoreEventRegister((Object)this.sheet, (ICoreEventListener)this);
            this.eventRegister.register("markerGroupAdd");
            this.eventRegister.register("markerGroupRemove");
        }

        private void uninstallListeners() {
            if (this.eventRegister != null) {
                this.eventRegister.unregisterAll();
            }
        }

        public void dispose() {
            this.uninstallListeners();
            if (this.composite != null) {
                this.composite.dispose();
                this.composite = null;
            }
            Object[] objectArray = this.groupParts.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                MarkerGroupPart groupPart = (MarkerGroupPart)o;
                MarkerPart.this.groupToPart.remove(groupPart.getMarkerGroup());
                MarkerPart.this.groupToSection.remove(groupPart.getMarkerGroup());
                groupPart.dispose();
                ++n2;
            }
            this.groupParts.clear();
            this.groupSections.clear();
        }

        public void handleCoreEvent(final CoreEvent event) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            this.composite.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String type = event.getType();
                    if ("markerGroupAdd".equals(type) || "markerGroupRemove".equals(type)) {
                        MarkerSheetPart.this.refresh(true);
                    }
                }
            });
        }
    }
}

