/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.xmind.core.IComment;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.commands.DeleteCommentCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentAction;
import org.xmind.ui.mindmap.MindMapUI;

public class DeleteCommentAction
extends CommentAction {
    private IComment comment;

    public DeleteCommentAction(IGraphicalEditor editor) {
        super(editor);
        this.setId("org.xmind.ui.action.deleteComment");
        this.setText(MindMapMessages.DeleteComment_text);
        this.setImageDescriptor(MindMapUI.getImages().get("delete-comment.png", true));
        this.setDisabledImageDescriptor(MindMapUI.getImages().get("delete-comment.png", false));
        this.setToolTipText(MindMapMessages.DeleteComment_tooltip);
    }

    @Override
    public void run() {
        if (this.comment == null) {
            return;
        }
        Object target = this.comment.getOwnedWorkbook().getElementById(this.comment.getObjectId());
        if (target == null) {
            return;
        }
        DeleteCommentCommand cmd = new DeleteCommentCommand(target, this.comment);
        ICommandStack commandStack = this.getCommandStack();
        if (commandStack != null) {
            commandStack.execute((Command)cmd);
        } else {
            cmd.execute();
        }
    }

    @Override
    public void selectedCommentChanged(IComment comment) {
        this.comment = comment;
        this.setEnabled(comment != null);
    }
}

