/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.IAdaptable;
import org.xmind.core.IDeserializer;
import org.xmind.core.IManifest;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.MarkerGroup;
import org.xmind.core.internal.MarkerVariation;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.io.BundleResource;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.AbstractMarkerResource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerResourceAllocator;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.marker.IMarkerVariation;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IPropertiesProvider;
import org.xmind.ui.internal.ClonedTemplate;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.TemplateGroup;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.IResourceManagerListener;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.ITemplateGroup;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.ResourceFinder;
import org.xmind.ui.util.XMLUtils;

public class MindMapResourceManager
implements IResourceManager {
    private static final String DEFAULT_THEME_ID = "xminddefaultthemeid";
    private static final String PATH_MARKERS = "markers/";
    private static final String PATH_USER_MARKERS = "markers/";
    private static final String PATH_STYLES = "styles/";
    private static final String PATH_STYLES_DIR = "$nl$/styles/";
    private static final String PATH_USER_STYLES = "styles/userStyles/";
    private static final String PATH_USER_THEMES = "styles/userThemes/";
    private static final String MARKER_SHEET_XML = "markerSheet.xml";
    private static final String MARKER_SHEET = "markerSheet";
    private static final String DEFAULT_STYLES_XML = "defaultStyles.xml";
    private static final String STYLES = "styles";
    private static final String THEMES = "themes";
    private static final String EXT_PROPERTIES = ".properties";
    private static final String EXT_XML = ".xml";
    private static final String SYS_TEMPLATES_DIR = "$nl$/templates/";
    private static final String SYS_TEMPLATES_XML_PATH = "$nl$/templates/templates.xml";
    private static final String USER_TEMPLATES_DIR = "templates/";
    private static final String PATH_TEMPLATES = "templates/";
    private static final String TEMPLATES = "templates";
    private IMarkerSheet systemMarkerSheet = null;
    private IMarkerSheet userMarkerSheet = null;
    private IMarkerGroup recentMarkerGroup = null;
    private IStyleSheet defaultStyleSheet = null;
    private IStyleSheet systemStyleSheet = null;
    private IWorkbook userStylesContainer = null;
    private IStyle blankTheme = null;
    private IStyle defaultTheme = null;
    private IStyleSheet systemThemeSheet = null;
    private IWorkbook userThemesContainer = null;
    private ITemplate defaultTemplate;
    private ListenerList resourceManagerListeners = new ListenerList();
    private static final String SCHEMA_MARKER = "marker";
    private static final String SCHEMA_STYLE = "style";
    private static final String SCHEMA_THEME = "theme";
    private static final String CATEGORY_SYSTEM = "system";
    private static final String CATEGORY_USER = "user";
    private static final String CATEGORY_DEFAULT = "default";
    private static final String GROUP_ANY = "any";
    private static final String ID_BLANK = "blank";
    private static final String ID_DEFAULT = "__default__";

    @Override
    public IMarkerSheet getSystemMarkerSheet() {
        if (this.systemMarkerSheet == null) {
            this.systemMarkerSheet = this.createSystemMarkerShet();
        }
        return this.systemMarkerSheet;
    }

    private IMarkerSheet createSystemMarkerShet() {
        URL url = MindMapResourceManager.find("markers/", MARKER_SHEET_XML);
        if (url != null) {
            try {
                IMarkerSheet sheet = Core.getMarkerSheetBuilder().loadFromURL(url, (IMarkerResourceProvider)new SystemMarkerResourceProvider());
                MindMapResourceManager.loadPropertiesFor((IAdaptable)sheet, "markers/", MARKER_SHEET);
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load system marker from: " + url);
            }
        }
        return Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new SystemMarkerResourceProvider());
    }

    @Override
    public IMarkerSheet getUserMarkerSheet() {
        if (this.userMarkerSheet == null) {
            this.userMarkerSheet = this.createUserMarkerSheet();
            this.initUserMarkerSheet(this.userMarkerSheet);
        }
        return this.userMarkerSheet;
    }

    @Override
    public void saveUserMarkerSheet() {
        block13: {
            if (this.userMarkerSheet != null) {
                String path = Core.getWorkspace().getAbsolutePath("markers/markerSheet.xml");
                File file = FileUtils.ensureFileParent((File)new File(path));
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(file);
                        this.userMarkerSheet.save((OutputStream)out);
                    }
                    catch (Exception e) {
                        Logger.log(e);
                        if (out == null) break block13;
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            Logger.log(e2);
                        }
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            Logger.log(e);
                        }
                    }
                }
            }
        }
    }

    private void initUserMarkerSheet(IMarkerSheet sheet) {
        sheet.setParentSheet(this.getSystemMarkerSheet());
    }

    private IMarkerSheet createUserMarkerSheet() {
        File file;
        String path = Core.getWorkspace().getAbsolutePath("markers/markerSheet.xml");
        if (path != null && (file = new File(path)).exists()) {
            try {
                return Core.getMarkerSheetBuilder().loadFromFile(file, (IMarkerResourceProvider)new UserMarkerResourceProvider());
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load user marker from: " + file);
            }
        }
        return Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new UserMarkerResourceProvider());
    }

    @Override
    public IMarkerGroup getRecentMarkerGroup() {
        if (this.recentMarkerGroup == null) {
            this.recentMarkerGroup = new RecentMarkerGroup();
        }
        return this.recentMarkerGroup;
    }

    @Override
    public IStyleSheet getDefaultStyleSheet() {
        if (this.defaultStyleSheet == null) {
            this.defaultStyleSheet = this.createDefaultStyleSheet();
        }
        return this.defaultStyleSheet;
    }

    private IStyleSheet createDefaultStyleSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES, DEFAULT_STYLES_XML);
        if (url != null) {
            try {
                return Core.getStyleSheetBuilder().loadFromUrl(url);
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load default styles: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    @Override
    public IStyleSheet getSystemStyleSheet() {
        if (this.systemStyleSheet == null) {
            this.systemStyleSheet = this.createSystemStyleSheet();
            IManifest manifest = Core.getWorkbookBuilder().createWorkbook().getManifest();
            ((StyleSheetImpl)this.systemStyleSheet).setManifest(manifest);
        }
        return this.systemStyleSheet;
    }

    private IStyleSheet createSystemStyleSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES, STYLES, EXT_XML);
        if (url != null) {
            try {
                IStyleSheet sheet = Core.getStyleSheetBuilder().loadFromUrl(url);
                MindMapResourceManager.loadPropertiesFor((IAdaptable)sheet, PATH_STYLES, STYLES);
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Falied to load saved styles: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    @Override
    public IStyleSheet getUserStyleSheet() {
        if (this.userStylesContainer == null) {
            this.userStylesContainer = MindMapResourceManager.loadResourceContainer(PATH_USER_STYLES);
        }
        return this.userStylesContainer.getStyleSheet();
    }

    @Override
    public void saveUserStyleSheet() {
        MindMapResourceManager.saveResourceContainer(this.userStylesContainer, PATH_USER_STYLES);
    }

    @Override
    public IStyle getBlankTheme() {
        if (this.blankTheme == null) {
            this.blankTheme = Core.getStyleSheetBuilder().createStyleSheet().createStyle(SCHEMA_THEME);
            this.blankTheme.setName(MindMapMessages.DefaultTheme_title);
        }
        return this.blankTheme;
    }

    @Override
    public IStyle getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = this.findDefaultTheme();
        }
        return this.checkDefaultTheme(this.defaultTheme);
    }

    private IStyle checkDefaultTheme(IStyle defaultTheme) {
        String defaultId = defaultTheme.getId();
        boolean exist = this.getSystemThemeSheet().findStyle(defaultId) != null || this.getUserThemeSheet().findStyle(defaultId) != null || this.getBlankTheme().getId().equals(defaultId);
        return exist ? defaultTheme : this.getSystemThemeSheet().findStyle(DEFAULT_THEME_ID);
    }

    private IStyle findDefaultTheme() {
        String defaultId;
        if (Platform.isRunning() && (defaultId = MindMapUIPlugin.getDefault().getPreferenceStore().getString("defaultTheme")) != null && !"".equals(defaultId)) {
            IStyle theme = this.getSystemThemeSheet().findStyle(defaultId);
            if (theme == null) {
                theme = this.getUserThemeSheet().findStyle(defaultId);
            }
            if (theme == null && defaultId.equals(this.getBlankTheme().getId())) {
                theme = this.getBlankTheme();
            }
            if (theme != null) {
                return theme;
            }
        }
        return this.getSystemThemeSheet().findStyle(DEFAULT_THEME_ID);
    }

    @Override
    public void setDefaultTheme(String id) {
        IStyle theme = null;
        if (id != null && !"".equals(id) && !id.equals((theme = this.getSystemThemeSheet().findStyle(DEFAULT_THEME_ID)).getId())) {
            theme = this.getSystemThemeSheet().findStyle(id);
            if (theme == null) {
                theme = this.getUserThemeSheet().findStyle(id);
            }
            if (theme == null && id.equals(this.getBlankTheme().getId())) {
                theme = this.getBlankTheme();
            }
        }
        if (theme == null) {
            id = null;
        }
        this.defaultTheme = theme;
        MindMapUIPlugin.getDefault().getPreferenceStore().setValue("defaultTheme", id);
    }

    @Override
    public IStyleSheet getSystemThemeSheet() {
        if (this.systemThemeSheet == null) {
            this.systemThemeSheet = this.createSystemThemeSheet();
            IManifest manifest = Core.getWorkbookBuilder().createWorkbook().getManifest();
            ((StyleSheetImpl)this.systemThemeSheet).setManifest(manifest);
        }
        return this.systemThemeSheet;
    }

    private IStyleSheet createSystemThemeSheet() {
        URL url = MindMapResourceManager.find(PATH_STYLES_DIR, THEMES, EXT_XML);
        if (url != null) {
            try {
                IStyleSheet sheet = Core.getStyleSheetBuilder().loadFromUrl(url);
                MindMapResourceManager.loadPropertiesFor((IAdaptable)sheet, PATH_STYLES, THEMES);
                return sheet;
            }
            catch (Exception e) {
                Logger.log(e, "Falied to load system themes: " + url);
            }
        }
        return Core.getStyleSheetBuilder().createStyleSheet();
    }

    @Override
    public IStyleSheet getUserThemeSheet() {
        if (this.userThemesContainer == null) {
            this.userThemesContainer = MindMapResourceManager.loadResourceContainer(PATH_USER_THEMES);
        }
        return this.userThemesContainer.getStyleSheet();
    }

    @Override
    public void saveUserThemeSheet() {
        MindMapResourceManager.saveResourceContainer(this.userThemesContainer, PATH_USER_THEMES);
    }

    private static IWorkbook loadResourceContainer(String sourcePath) {
        IWorkbook container = null;
        File file = new File(Core.getWorkspace().getAbsolutePath(sourcePath));
        File tempLoc = new File(Core.getWorkspace().getTempDir(sourcePath));
        FileUtils.ensureDirectory((File)tempLoc);
        DirectoryStorage tempStorage = new DirectoryStorage(tempLoc);
        if (file.exists() && file.isDirectory() && new File(file, "content.xml").exists()) {
            try {
                IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
                deserializer.setWorkbookStorage((IStorage)tempStorage);
                deserializer.setInputSource((IInputSource)new DirectoryInputSource(file));
                deserializer.deserialize(null);
                container = deserializer.getWorkbook();
            }
            catch (Exception e) {
                Logger.log(e, "Failed to load user styles from: " + file);
            }
        }
        if (container == null) {
            container = Core.getWorkbookBuilder().createWorkbook((IStorage)tempStorage);
        }
        return container;
    }

    private static void saveResourceContainer(IWorkbook workbook, String targetPath) {
        if (workbook == null) {
            return;
        }
        File file = new File(Core.getWorkspace().getAbsolutePath(targetPath));
        FileUtils.ensureDirectory((File)file);
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setOutputTarget((IOutputTarget)new DirectoryOutputTarget(file));
            serializer.serialize(null);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private static URL find(String fullPath) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        if (bundle != null) {
            return FileLocator.find((Bundle)bundle, (IPath)new Path(fullPath), null);
        }
        return null;
    }

    private static URL find(String mainPath, String subPath) {
        return MindMapResourceManager.find(String.valueOf(mainPath) + subPath);
    }

    private static URL find(String mainPath, String prefix, String suffix) {
        return ResourceFinder.findResource("org.xmind.ui", mainPath, prefix, suffix);
    }

    private static void loadPropertiesFor(IAdaptable resourceManager, String mainPath, String propertiesFilePrefix) {
        IPropertiesProvider propertiesProvider = (IPropertiesProvider)resourceManager.getAdapter(IPropertiesProvider.class);
        if (propertiesProvider == null) {
            return;
        }
        Properties defaultProperties = new Properties();
        URL defaultPropertiesURL = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui"), (IPath)new Path(String.valueOf(mainPath) + propertiesFilePrefix + EXT_PROPERTIES), null);
        if (defaultPropertiesURL != null) {
            try {
                InputStream stream = defaultPropertiesURL.openStream();
                try {
                    defaultProperties.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to load default properties file from: " + mainPath + propertiesFilePrefix + EXT_PROPERTIES);
            }
        }
        Properties properties = new Properties(defaultProperties);
        URL propertiesURL = MindMapResourceManager.find(mainPath, propertiesFilePrefix, EXT_PROPERTIES);
        if (propertiesURL != null) {
            try {
                InputStream stream = propertiesURL.openStream();
                try {
                    properties.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to load locale-specific properties file from: " + mainPath + propertiesFilePrefix + EXT_PROPERTIES);
            }
        }
        propertiesProvider.setProperties(properties);
    }

    @Override
    public Object findResource(String uri) {
        if (uri == null) {
            return null;
        }
        int sep = uri.indexOf(58);
        if (sep < 0) {
            return null;
        }
        String schema = uri.substring(0, sep);
        String path = uri.substring(sep + 1);
        String[] segments = path.split("/");
        if (segments.length == 0) {
            return null;
        }
        String category = segments[0];
        if (SCHEMA_MARKER.equals(schema)) {
            IMarkerGroup markerGroup;
            IMarkerSheet markerSheet = this.findMarkerSheet(category);
            if (markerSheet == null || segments.length == 1) {
                return markerSheet;
            }
            String groupId = segments[1];
            boolean anyGroup = GROUP_ANY.equals(groupId);
            IMarkerGroup iMarkerGroup = markerGroup = anyGroup ? null : markerSheet.findMarkerGroup(groupId);
            if (segments.length == 2) {
                return markerGroup;
            }
            String markerId = segments[2];
            if (markerGroup == null) {
                return anyGroup ? markerSheet.findMarker(markerId) : null;
            }
            return markerGroup.getMarker(markerId);
        }
        if (SCHEMA_STYLE.equals(schema)) {
            IStyleSheet styleSheet = this.findStyleSheet(category);
            if (styleSheet == null || segments.length == 1) {
                return styleSheet;
            }
            String styleId = segments[1];
            return styleSheet.findStyle(styleId);
        }
        if (SCHEMA_THEME.equals(schema)) {
            IStyleSheet themeSheet = this.findThemeSheet(category);
            if (themeSheet == null || segments.length == 1) {
                return themeSheet;
            }
            String styleId = segments[1];
            if (themeSheet == this.getSystemThemeSheet()) {
                if (ID_BLANK.equals(styleId)) {
                    return this.getBlankTheme();
                }
                if (ID_DEFAULT.equals(styleId)) {
                    return this.getDefaultTheme();
                }
            }
            return themeSheet.findStyle(styleId);
        }
        return null;
    }

    private IMarkerSheet findMarkerSheet(String category) {
        if (CATEGORY_SYSTEM.equals(category)) {
            return this.getSystemMarkerSheet();
        }
        if (CATEGORY_USER.equals(category)) {
            return this.getUserMarkerSheet();
        }
        return null;
    }

    private IStyleSheet findStyleSheet(String category) {
        if (CATEGORY_DEFAULT.equals(category)) {
            return this.getDefaultStyleSheet();
        }
        if (CATEGORY_SYSTEM.equals(category)) {
            return this.getSystemStyleSheet();
        }
        if (CATEGORY_USER.equals(category)) {
            return this.getUserStyleSheet();
        }
        return null;
    }

    private IStyleSheet findThemeSheet(String category) {
        if (CATEGORY_SYSTEM.equals(category)) {
            return this.getSystemThemeSheet();
        }
        if (CATEGORY_USER.equals(category)) {
            return this.getUserThemeSheet();
        }
        return null;
    }

    @Override
    public String toResourceURI(Object resource) {
        if (resource instanceof IMarkerSheet) {
            if (resource == this.getSystemMarkerSheet()) {
                return "marker:system";
            }
            if (resource == this.getUserMarkerSheet()) {
                return "marker:user";
            }
            return null;
        }
        if (resource instanceof IMarkerGroup) {
            IMarkerGroup markerGroup = (IMarkerGroup)resource;
            IMarkerSheet markerSheet = markerGroup.getParent();
            if (markerSheet == this.getSystemMarkerSheet()) {
                return "marker:system/" + markerGroup.getId();
            }
            if (markerSheet == this.getUserMarkerSheet()) {
                return "marker:user/" + markerGroup.getId();
            }
            return null;
        }
        if (resource instanceof IMarker) {
            IMarker marker = (IMarker)resource;
            IMarkerGroup markerGroup = marker.getParent();
            if (markerGroup == null) {
                return null;
            }
            IMarkerSheet markerSheet = markerGroup.getParent();
            if (markerSheet == this.getSystemMarkerSheet()) {
                return "marker:system/" + markerGroup.getId() + "/" + marker.getId();
            }
            if (markerSheet == this.getUserMarkerSheet()) {
                return "marker:user/" + markerGroup.getId() + "/" + marker.getId();
            }
            return null;
        }
        if (resource instanceof IStyleSheet) {
            if (resource == this.getDefaultStyleSheet()) {
                return "style:default";
            }
            if (resource == this.getSystemStyleSheet()) {
                return "style:system";
            }
            if (resource == this.getUserStyleSheet()) {
                return "style:user";
            }
            if (resource == this.getSystemThemeSheet()) {
                return "theme:system";
            }
            if (resource == this.getUserThemeSheet()) {
                return "theme:user";
            }
        }
        if (resource instanceof IStyle) {
            if (resource == this.getBlankTheme()) {
                return "theme:system/blank";
            }
            IStyle style = (IStyle)resource;
            IStyleSheet styleSheet = style.getOwnedStyleSheet();
            if (styleSheet == this.getDefaultStyleSheet()) {
                return "style:default/" + style.getId();
            }
            if (styleSheet == this.getSystemStyleSheet()) {
                return "style:system/" + style.getId();
            }
            if (styleSheet == this.getUserStyleSheet()) {
                return "style:user/" + style.getId();
            }
            if (styleSheet == this.getSystemThemeSheet()) {
                return "theme:system/" + style.getId();
            }
            if (styleSheet == this.getUserThemeSheet()) {
                return "theme:user/" + style.getId();
            }
        }
        return null;
    }

    @Override
    public List<ITemplate> getSystemTemplates() {
        ArrayList<ITemplate> sysTemplates = new ArrayList<ITemplate>();
        this.loadSystemTemplates(sysTemplates);
        return sysTemplates;
    }

    @Override
    public List<ITemplateGroup> getSystemTemplateGroups() {
        ArrayList<ITemplateGroup> sysTemplateGroups = new ArrayList<ITemplateGroup>();
        this.loadSystemTemplateGroups(sysTemplateGroups);
        return sysTemplateGroups;
    }

    private void loadSystemTemplateGroups(List<ITemplateGroup> sysTemplateGroups) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        if (bundle == null) {
            return;
        }
        BundleResource listXMLResource = new BundleResource(bundle, (IPath)new Path(SYS_TEMPLATES_XML_PATH)).resolve();
        if (listXMLResource == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to locate system template xml: " + bundle.getSymbolicName() + "/" + SYS_TEMPLATES_XML_PATH));
            return;
        }
        URL listXMLURL = listXMLResource.toPlatformURL();
        Element element = this.getTemplateListElement(listXMLURL);
        if (element == null) {
            return;
        }
        Properties properties = this.getTemplateListProperties(bundle);
        Iterator categoryIt = DOMUtils.childElementIterByTag((Node)element, (String)"category");
        while (categoryIt.hasNext()) {
            Element categoryEle = (Element)categoryIt.next();
            String name = categoryEle.getAttribute("name");
            if (name.startsWith("%")) {
                name = properties != null ? properties.getProperty(name.substring(1)) : null;
            }
            TemplateGroup templateGroup = new TemplateGroup(name);
            Iterator templateIt = DOMUtils.childElementIterByTag((Node)categoryEle, (String)"template");
            ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
            this.loadTemplates(templates, templateIt, bundle);
            templateGroup.setTemplates(templates);
            sysTemplateGroups.add(templateGroup);
        }
    }

    private void loadSystemTemplates(List<ITemplate> templates) {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        if (bundle == null) {
            return;
        }
        BundleResource listXMLResource = new BundleResource(bundle, (IPath)new Path(SYS_TEMPLATES_XML_PATH)).resolve();
        if (listXMLResource == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to locate system template xml: " + bundle.getSymbolicName() + "/" + SYS_TEMPLATES_XML_PATH));
            return;
        }
        URL listXMLURL = listXMLResource.toPlatformURL();
        Element element = this.getTemplateListElement(listXMLURL);
        if (element == null) {
            return;
        }
        Iterator it = DOMUtils.childElementIterByTag((Node)element, (String)"template");
        this.loadTemplates(templates, it, bundle);
    }

    private void loadTemplates(List<ITemplate> templates, Iterator<Element> it, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Properties properties = this.getTemplateListProperties(bundle);
        while (it.hasNext()) {
            String name;
            URI resourceURI;
            Element templateEle = it.next();
            String resource = templateEle.getAttribute("resource");
            if (resource == null || "".equals(resource)) continue;
            try {
                resourceURI = URIUtil.toURI((URL)new URL(resource));
            }
            catch (IOException e) {
                MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to load system template: " + resource, (Throwable)e));
                continue;
            }
            catch (URISyntaxException e) {
                MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to load system template: " + resource, (Throwable)e));
                continue;
            }
            if (!resourceURI.isAbsolute()) {
                BundleResource templateResource = new BundleResource(Platform.getBundle((String)"org.xmind.ui"), (IPath)new Path(SYS_TEMPLATES_DIR + resource)).resolve();
                try {
                    resourceURI = templateResource.toPlatformURL().toURI();
                }
                catch (URISyntaxException e) {
                    MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to load system template: " + resource, (Throwable)e));
                    continue;
                }
            }
            if ((name = templateEle.getAttribute("name")).startsWith("%")) {
                name = properties != null ? properties.getProperty(name.substring(1)) : null;
            }
            if (name == null || "".equals(name)) {
                name = FileUtils.getNoExtensionFileName((String)resource);
            }
            templates.add(new ClonedTemplate(resourceURI, name));
        }
    }

    private Properties getTemplateListProperties(Bundle bundle) {
        final IPropertiesProvider provider = new IPropertiesProvider(){
            Properties properties;

            public void setProperties(Properties properties) {
                this.properties = properties;
            }

            public Properties getProperties() {
                return this.properties;
            }
        };
        IAdaptable adaptable = new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == IPropertiesProvider.class) {
                    return adapter.cast(provider);
                }
                return null;
            }
        };
        MindMapResourceManager.loadPropertiesFor(adaptable, "templates/", TEMPLATES);
        return provider.getProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element getTemplateListElement(URL xmlURL) {
        xmlURL = FileLocator.find((URL)xmlURL);
        try {
            InputStream is = xmlURL.openStream();
            if (is == null) return null;
            try {
                Document doc = XMLUtils.getDefaultDocumentBuilder().parse(is);
                if (doc == null) return null;
                Element element = doc.getDocumentElement();
                return element;
            }
            finally {
                is.close();
            }
        }
        catch (Throwable e) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to load template list from " + xmlURL.toExternalForm(), e));
        }
        return null;
    }

    private File createNonConflictingFile(File rootDir, String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        String name = dotIndex < 0 ? fileName : fileName.substring(0, dotIndex);
        String ext = dotIndex < 0 ? "" : fileName.substring(dotIndex);
        File targetFile = new File(rootDir, fileName);
        int i = 1;
        while (targetFile.exists()) {
            targetFile = new File(rootDir, String.format("%s %s%s", name, ++i, ext));
        }
        return targetFile;
    }

    @Override
    public List<ITemplate> getUserTemplates() {
        ArrayList<ITemplate> customTemplates = new ArrayList<ITemplate>();
        this.loadUserTemplates(customTemplates);
        return customTemplates;
    }

    private void loadUserTemplates(List<ITemplate> templates) {
        this.loadTemplatesFromDir(templates, MindMapResourceManager.getUserTemplatesDir());
    }

    private static File getUserTemplatesDir() {
        return new File(Core.getWorkspace().getAbsolutePath("templates/"));
    }

    private void loadTemplatesFromDir(List<ITemplate> templates, File templatesDir) {
        ArrayList<ClonedTemplate> list = new ArrayList<ClonedTemplate>();
        if (templatesDir != null && templatesDir.isDirectory()) {
            String[] stringArray = templatesDir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                String fileName = stringArray[n2];
                if ((fileName.endsWith(".xmt") || fileName.endsWith(".xmind")) && ((file = new File(templatesDir, fileName)).isFile() && file.canRead() || file.isDirectory())) {
                    list.add(new ClonedTemplate(file.toURI(), null));
                }
                ++n2;
            }
        }
        Collections.sort(list, new Comparator<ITemplate>(){

            @Override
            public int compare(ITemplate t1, ITemplate t2) {
                if (!(t1 instanceof ClonedTemplate) || !(t2 instanceof ClonedTemplate)) {
                    return 0;
                }
                ClonedTemplate ct1 = (ClonedTemplate)t1;
                ClonedTemplate ct2 = (ClonedTemplate)t2;
                File f1 = URIUtil.toFile((URI)ct1.getSourceWorkbookURI());
                File f2 = URIUtil.toFile((URI)ct2.getSourceWorkbookURI());
                if (f1 == null || f2 == null || !f1.exists() || !f2.exists()) {
                    return 0;
                }
                return (int)(f1.lastModified() - f2.lastModified());
            }
        });
        templates.addAll(list);
    }

    @Override
    public ITemplate addUserTemplateFromWorkbookURI(URI workbookURI) throws InvocationTargetException {
        Assert.isNotNull((Object)workbookURI);
        final IWorkbookRef sourceWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(workbookURI, null);
        if (sourceWorkbookRef == null) {
            throw new IllegalArgumentException("Invalid workbook URI: " + workbookURI);
        }
        File userTemplateFile = this.createUserTemplateOutputFile(String.valueOf(sourceWorkbookRef.getName()) + ".xmt");
        URI templateURI = userTemplateFile.toURI();
        final IWorkbookRef templateWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(templateURI, null);
        if (templateWorkbookRef == null) {
            throw new IllegalStateException("Failed to obtain workbook ref for local file URI: " + templateURI);
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    sourceWorkbookRef.open((IProgressMonitor)subMonitor.newChild(30));
                    try {
                        templateWorkbookRef.importFrom((IProgressMonitor)subMonitor.newChild(60), sourceWorkbookRef);
                    }
                    finally {
                        subMonitor.setWorkRemaining(10);
                        sourceWorkbookRef.close((IProgressMonitor)subMonitor.newChild(10));
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getProgressService().run(false, true, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        ClonedTemplate template = new ClonedTemplate(templateURI, FileUtils.getNoExtensionFileName((String)userTemplateFile.getAbsolutePath()));
        this.fireUserTemplateAdded(template);
        return template;
    }

    private void fireUserTemplateAdded(final ITemplate template) {
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IResourceManagerListener)listener).userTemplateAdded(template);
                }
            });
            ++n2;
        }
    }

    private void fireUserTemplateRemoved(final ITemplate template) {
        Object[] objectArray = this.resourceManagerListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IResourceManagerListener)listener).userTemplateRemoved(template);
                }
            });
            ++n2;
        }
    }

    private File createUserTemplateOutputFile(String fileName) {
        File dir = MindMapResourceManager.getUserTemplatesDir();
        FileUtils.ensureDirectory((File)dir);
        File file = this.createNonConflictingFile(dir, fileName);
        file.mkdirs();
        return file;
    }

    @Override
    public void removeUserTemplate(ITemplate template) {
        URI templateURI = template.getSourceWorkbookURI();
        if (URIUtil.isFileURI((URI)templateURI)) {
            File templateFile = URIUtil.toFile((URI)templateURI);
            File templatesDir = MindMapResourceManager.getUserTemplatesDir();
            if (templatesDir.equals(templateFile.getParentFile())) {
                FileUtils.delete((File)templateFile);
                this.fireUserTemplateRemoved(template);
            }
        }
    }

    @Override
    public void addResourceManagerListener(IResourceManagerListener listener) {
        this.resourceManagerListeners.add((Object)listener);
    }

    @Override
    public void removeResourceManagerListener(IResourceManagerListener listener) {
        this.resourceManagerListeners.remove((Object)listener);
    }

    @Override
    public ITemplate getDefaultTemplate() {
        return this.defaultTemplate;
    }

    @Override
    public void setDefaultTemplate(ITemplate defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    @Override
    public boolean isUserTemplate(ITemplate template) {
        URI templateURI = template.getSourceWorkbookURI();
        if (URIUtil.isFileURI((URI)templateURI)) {
            File templateFile = URIUtil.toFile((URI)templateURI);
            File templatesDir = MindMapResourceManager.getUserTemplatesDir();
            return templatesDir.equals(templateFile.getParentFile());
        }
        return false;
    }

    @Override
    public boolean isSystemTemplate(ITemplate template) {
        boolean isSysTemplate = this.getSystemTemplates().contains(template);
        List<ITemplateGroup> systemTemplateGroups = this.getSystemTemplateGroups();
        for (ITemplateGroup group : systemTemplateGroups) {
            if (!group.getTemplates().contains(template)) continue;
            return true;
        }
        return isSysTemplate;
    }

    protected static class RecentMarkerGroup
    extends MarkerGroup
    implements ICoreEventSource {
        public static final RecentMarkerGroup instance = new RecentMarkerGroup();
        private static final int CAPACITY = 20;
        private List<IMarker> markers = new ArrayList<IMarker>(20);
        private ICoreEventSupport eventSupport = new CoreEventSupport();

        private RecentMarkerGroup() {
        }

        /*
         * Unable to fully structure code
         */
        public void addMarker(IMarker marker) {
            if (!this.markers.contains(marker)) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                this.markers.remove(this.markers.size() - 1);
lbl5:
                // 2 sources

                ** while (this.markers.size() >= 20)
            }
lbl6:
            // 1 sources

            this.markers.add(0, marker);
            this.eventSupport.dispatchTargetChange((ICoreEventSource)this, "markerAdd", (Object)marker);
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == ICoreEventSource.class) {
                return adapter.cast((Object)this);
            }
            return (T)super.getAdapter(adapter);
        }

        public List<IMarker> getMarkers() {
            return this.markers;
        }

        public boolean isEmpty() {
            return this.markers.isEmpty();
        }

        public String getName() {
            return MindMapMessages.RecentUsed;
        }

        public void setSingleton(boolean singleton) {
        }

        public IMarkerSheet getOwnedSheet() {
            return null;
        }

        public IMarkerSheet getParent() {
            return null;
        }

        public boolean isSingleton() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public void setHidden(boolean hidden) {
        }

        public void removeMarker(IMarker marker) {
            if (!this.markers.contains(marker)) {
                return;
            }
            this.markers.remove(marker);
            this.eventSupport.dispatchTargetChange((ICoreEventSource)this, "markerRemove", (Object)marker);
        }

        public void setName(String name) {
        }

        public String getId() {
            return "org.xmind.ui.RecentMarkerGroup";
        }

        public Object getRegisterKey() {
            return this.getId();
        }

        public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
            return this.eventSupport.registerCoreEventListener((ICoreEventSource)this, type, listener);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public ICoreEventSupport getCoreEventSupport() {
            return this.eventSupport;
        }
    }

    private static class SystemMarkerResource
    extends AbstractMarkerResource {
        public SystemMarkerResource(IMarker marker) {
            super(marker, "markers/");
        }

        public InputStream getInputStream() {
            return this.getInputStreamForPath(this.getFullPath(), 100);
        }

        public InputStream openInputStream(int zoom) throws IOException {
            return this.getInputStreamForPath(this.getFullPath(), zoom);
        }

        public InputStream openInputStream(IMarkerVariation variation, int zoom) throws IOException {
            return this.getInputStreamForPath(variation.getVariedPath(this.getFullPath()), zoom);
        }

        private InputStream getInputStreamForPath(String fullPath, int zoom) {
            String xfullPath = this.getxPath(fullPath, zoom);
            URL url = MindMapResourceManager.find(xfullPath);
            if (url == null) {
                url = MindMapResourceManager.find(fullPath);
            }
            if (url == null) {
                return null;
            }
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private String getxPath(String path, int zoom) {
            int dot = path.lastIndexOf(46);
            if (dot != -1 && zoom > 100) {
                String lead = path.substring(0, dot);
                String tail = path.substring(dot);
                String x = "@2x";
                return String.valueOf(lead) + x + tail;
            }
            return path;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public InputStream openInputStream() throws IOException {
            URL url = MindMapResourceManager.find(this.getFullPath());
            if (url == null) {
                throw new FileNotFoundException(this.getFullPath());
            }
            return url.openStream();
        }

        public OutputStream openOutputStream() throws IOException {
            throw new FileNotFoundException("System marker is read only.");
        }

        protected void loadVariations(List<IMarkerVariation> variations) {
            MarkerVariation v = new MarkerVariation("@16", 16, 16);
            if (MindMapResourceManager.find(v.getVariedPath(this.getFullPath())) != null) {
                variations.add((IMarkerVariation)v);
            }
            if (MindMapResourceManager.find((v = new MarkerVariation("@24", 24, 24)).getVariedPath(this.getFullPath())) != null) {
                variations.add((IMarkerVariation)v);
            }
            if (MindMapResourceManager.find((v = new MarkerVariation("@32", 32, 32)).getVariedPath(this.getFullPath())) != null) {
                variations.add((IMarkerVariation)v);
            }
        }

        public InputStream getInputStream(IMarkerVariation variation) {
            return this.getInputStreamForPath(variation.getVariedPath(this.getFullPath()), 100);
        }

        public InputStream openInputStream(IMarkerVariation variation) throws IOException {
            InputStream stream = this.getInputStreamForPath(variation.getVariedPath(this.getFullPath()), 100);
            if (stream == null) {
                throw new FileNotFoundException();
            }
            return stream;
        }

        public OutputStream getOutputStream(IMarkerVariation variation) {
            return null;
        }

        public OutputStream openOutputStream(IMarkerVariation variation) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof SystemMarkerResource)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    private static class SystemMarkerResourceProvider
    implements IMarkerResourceProvider {
        private SystemMarkerResourceProvider() {
        }

        public IMarkerResource getMarkerResource(IMarker marker) {
            return new SystemMarkerResource(marker);
        }

        public boolean isPermanent() {
            return true;
        }
    }

    private static class UserMarkerResource
    extends AbstractMarkerResource {
        private final String JPG_FORMAT = "jpg";
        private final String JPEG_FORMAT = "jpeg";
        private final String PNG_FORMAT = "png";

        public UserMarkerResource(IMarker marker) {
            super(marker, "markers/");
        }

        private File getFile() {
            File origin = FileUtils.ensureFileParent((File)new File(Core.getWorkspace().getAbsolutePath(this.getFullPath())));
            String lowerFullPath = this.getFullPath().toLowerCase();
            if (lowerFullPath.endsWith("jpeg") || lowerFullPath.endsWith("jpg")) {
                try {
                    String jpg = Core.getWorkspace().getAbsolutePath(this.getFullPath());
                    BufferedImage source = ImageIO.read(new File(jpg));
                    String png = String.valueOf(jpg.substring(0, jpg.lastIndexOf(46) - 1)) + "png";
                    File pngFile = new File(png);
                    ImageIO.write((RenderedImage)source, "png", pngFile);
                    return pngFile;
                }
                catch (Exception exception) {}
            }
            return origin;
        }

        public InputStream getInputStream() {
            File file = this.getFile();
            if (file != null) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }

        public OutputStream getOutputStream() {
            File file = this.getFile();
            if (file != null) {
                try {
                    return new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.getFile());
        }

        public OutputStream openOutputStream() throws IOException {
            return new FileOutputStream(this.getFile());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof UserMarkerResource)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    private static class UserMarkerResourceProvider
    implements IMarkerResourceProvider,
    IMarkerResourceAllocator {
        private UserMarkerResourceProvider() {
        }

        public IMarkerResource getMarkerResource(IMarker marker) {
            return new UserMarkerResource(marker);
        }

        public boolean isPermanent() {
            return false;
        }

        public String allocateMarkerResource(InputStream source, String suggestedPath) throws IOException {
            String ext = suggestedPath == null ? ".png" : FileUtils.getExtension((String)suggestedPath);
            String path = String.valueOf(Core.getIdFactory().createId()) + ext;
            File file = new File(Core.getWorkspace().getAbsolutePath("markers/" + path));
            FileUtils.ensureFileParent((File)file);
            FileOutputStream target = new FileOutputStream(file);
            try {
                FileUtils.transfer((InputStream)source, (OutputStream)target, (boolean)false);
            }
            finally {
                ((OutputStream)target).close();
            }
            return path;
        }
    }
}

