/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.properties.IPropertyPagePart;
import org.xmind.gef.ui.properties.IPropertyPartContainer;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.gef.ui.properties.Messages;

public abstract class MultiPagePropertySheetPage
extends Page
implements ISelectionListener,
IPropertyPartContainer {
    private IGraphicalEditor editor;
    private Map<String, IPropertyPagePart> pages = new HashMap<String, IPropertyPagePart>();
    private IPropertyPagePart currentPage;
    private Composite composite;
    private PageBook pageBook;
    private Label titleBar;
    private Control titleSeparator;
    private Control defaultPage;

    public MultiPagePropertySheetPage(IGraphicalEditor editor) {
        this.editor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getPage().addPostSelectionListener((ISelectionListener)this);
        for (IPropertyPagePart page : this.pages.values()) {
            page.init(this, this.getContributedEditor());
        }
    }

    protected void addPage(String pageId, IPropertyPagePart page) {
        this.pages.put(pageId, page);
        page.init(this, this.editor);
    }

    protected void removePage(String pageId, IPropertyPagePart page) {
        if (this.pages.remove(pageId) == page) {
            Control control = page.getControl();
            if (control != null) {
                control.dispose();
            }
            page.dispose();
        }
    }

    public IGraphicalEditor getContributedEditor() {
        return this.editor;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 524288);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.titleBar = new Label(this.composite, 0);
        this.titleBar.setLayoutData((Object)new GridData(768));
        this.titleSeparator = new Label(this.composite, 258);
        this.titleSeparator.setLayoutData((Object)new GridData(768));
        this.pageBook = new PageBook(this.composite, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
    }

    private void showPage(IPropertyPagePart page) {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        if (page == null) {
            this.pageBook.showPage(this.getDefaultPage());
            return;
        }
        Control c = page.getControl();
        if (c == null || c.isDisposed()) {
            this.createPageControl(page);
            c = page.getControl();
        }
        if (c != null && !c.isDisposed()) {
            this.pageBook.showPage(c);
        }
    }

    protected void createPageControl(IPropertyPagePart page) {
        page.createControl((Composite)this.pageBook);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        } else if (this.pageBook != null && !this.pageBook.isDisposed()) {
            this.pageBook.setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this.editor) {
            return;
        }
        this.changeCurrentPage(selection);
        if (this.pageBook != null && !this.pageBook.isDisposed()) {
            this.showPage(this.currentPage);
            this.updateTitleBar();
            this.refresh();
        }
    }

    private void changeCurrentPage(ISelection selection) {
        IPropertyPagePart page = null;
        String pageId = this.getPageId(selection);
        if (pageId != null && (page = this.pages.get(pageId)) == null && (page = this.createPage(pageId, selection)) != null) {
            this.addPage(pageId, page);
        }
        if (page != this.currentPage) {
            if (this.currentPage != null) {
                this.currentPage.setSelection(null);
            }
            this.currentPage = page;
        }
        if (this.currentPage != null) {
            this.currentPage.setSelection(selection);
        }
    }

    protected abstract IPropertyPagePart createPage(String var1, ISelection var2);

    private Control getDefaultPage() {
        if (this.defaultPage == null || this.defaultPage.isDisposed()) {
            this.defaultPage = this.createDefaultPage((Composite)this.pageBook);
        }
        return this.defaultPage;
    }

    protected Control createDefaultPage(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.propertiesNotAvailable);
        return label;
    }

    @Override
    public void updateSectionTitle(IPropertySectionPart section) {
        IPropertyPagePart page = this.findPage(section);
        if (page != null) {
            page.updateSectionTitle(section);
        }
    }

    private IPropertyPagePart findPage(IPropertySectionPart section) {
        for (IPropertyPagePart page : this.pages.values()) {
            if (!page.getSections().contains(section)) continue;
            return page;
        }
        return null;
    }

    private void updateTitleBar() {
        if (this.titleBar == null || this.titleBar.isDisposed()) {
            return;
        }
        String title = this.currentPage == null ? null : this.currentPage.getTitle();
        this.titleBar.setText(title == null ? "" : title);
        this.setTitleVisible(title != null);
    }

    private void setTitleVisible(boolean visible) {
        if (this.titleBar == null || this.titleBar.isDisposed()) {
            return;
        }
        if (this.titleBar.getVisible() == visible) {
            return;
        }
        this.titleBar.setVisible(visible);
        ((GridData)this.titleBar.getLayoutData()).exclude = !visible;
        this.titleSeparator.setVisible(visible);
        ((GridData)this.titleSeparator.getLayoutData()).exclude = !visible;
        this.composite.layout();
    }

    protected abstract String getPageId(ISelection var1);

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        for (IPropertyPagePart page : this.pages.values()) {
            page.dispose();
        }
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        this.pageBook = null;
        this.defaultPage = null;
        this.titleBar = null;
        this.titleSeparator = null;
        super.dispose();
    }

    @Override
    public void refresh() {
        for (IPropertyPagePart page : this.pages.values()) {
            page.refresh();
        }
    }

    @Override
    public IPageSite getContainerSite() {
        return this.getSite();
    }
}

