// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_disks/v1/region_disks.proto

#include "google/cloud/compute/region_disks/v1/region_disks_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_disks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionDisksClient::RegionDisksClient(
    std::shared_ptr<RegionDisksConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionDisksClient::~RegionDisksClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::AddResourcePolicies(
    std::string const& project, std::string const& region,
    std::string const& disk,
    google::cloud::cpp::compute::v1::
        RegionDisksAddResourcePoliciesRequest const&
            region_disks_add_resource_policies_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::AddResourcePoliciesRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  *request.mutable_region_disks_add_resource_policies_request_resource() =
      region_disks_add_resource_policies_request_resource;
  return connection_->AddResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::AddResourcePolicies(
    google::cloud::cpp::compute::region_disks::v1::
        AddResourcePoliciesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::BulkInsert(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::BulkInsertDiskResource const&
        bulk_insert_disk_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::BulkInsertRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_bulk_insert_disk_resource() = bulk_insert_disk_resource;
  return connection_->BulkInsert(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::BulkInsert(
    google::cloud::cpp::compute::region_disks::v1::BulkInsertRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkInsert(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::CreateSnapshot(
    std::string const& project, std::string const& region,
    std::string const& disk,
    google::cloud::cpp::compute::v1::Snapshot const& snapshot_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::CreateSnapshotRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  *request.mutable_snapshot_resource() = snapshot_resource;
  return connection_->CreateSnapshot(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::CreateSnapshot(
    google::cloud::cpp::compute::region_disks::v1::CreateSnapshotRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnapshot(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::DeleteDisk(std::string const& project,
                              std::string const& region,
                              std::string const& disk, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::DeleteDiskRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  return connection_->DeleteDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::DeleteDisk(
    google::cloud::cpp::compute::region_disks::v1::DeleteDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDisk(request);
}

StatusOr<google::cloud::cpp::compute::v1::Disk> RegionDisksClient::GetDisk(
    std::string const& project, std::string const& region,
    std::string const& disk, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::GetDiskRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  return connection_->GetDisk(request);
}

StatusOr<google::cloud::cpp::compute::v1::Disk> RegionDisksClient::GetDisk(
    google::cloud::cpp::compute::region_disks::v1::GetDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDisk(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionDisksClient::GetIamPolicy(std::string const& project,
                                std::string const& region,
                                std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::GetIamPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionDisksClient::GetIamPolicy(
    google::cloud::cpp::compute::region_disks::v1::GetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::InsertDisk(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::Disk const& disk_resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::InsertDiskRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_disk_resource() = disk_resource;
  return connection_->InsertDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::InsertDisk(
    google::cloud::cpp::compute::region_disks::v1::InsertDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertDisk(request);
}

StreamRange<google::cloud::cpp::compute::v1::Disk>
RegionDisksClient::ListRegionDisks(std::string const& project,
                                   std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::ListRegionDisksRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionDisks(request);
}

StreamRange<google::cloud::cpp::compute::v1::Disk>
RegionDisksClient::ListRegionDisks(
    google::cloud::cpp::compute::region_disks::v1::ListRegionDisksRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionDisks(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::RemoveResourcePolicies(
    std::string const& project, std::string const& region,
    std::string const& disk,
    google::cloud::cpp::compute::v1::
        RegionDisksRemoveResourcePoliciesRequest const&
            region_disks_remove_resource_policies_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::RemoveResourcePoliciesRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  *request.mutable_region_disks_remove_resource_policies_request_resource() =
      region_disks_remove_resource_policies_request_resource;
  return connection_->RemoveResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::RemoveResourcePolicies(
    google::cloud::cpp::compute::region_disks::v1::
        RemoveResourcePoliciesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::Resize(
    std::string const& project, std::string const& region,
    std::string const& disk,
    google::cloud::cpp::compute::v1::RegionDisksResizeRequest const&
        region_disks_resize_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::ResizeRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  *request.mutable_region_disks_resize_request_resource() =
      region_disks_resize_request_resource;
  return connection_->Resize(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::Resize(
    google::cloud::cpp::compute::region_disks::v1::ResizeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Resize(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionDisksClient::SetIamPolicy(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetPolicyRequest const&
        region_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::SetIamPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_policy_request_resource() =
      region_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionDisksClient::SetIamPolicy(
    google::cloud::cpp::compute::region_disks::v1::SetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::SetLabels(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetLabelsRequest const&
        region_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::SetLabelsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_labels_request_resource() =
      region_set_labels_request_resource;
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::SetLabels(
    google::cloud::cpp::compute::region_disks::v1::SetLabelsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StartAsyncReplication(
    std::string const& project, std::string const& region,
    std::string const& disk,
    google::cloud::cpp::compute::v1::
        RegionDisksStartAsyncReplicationRequest const&
            region_disks_start_async_replication_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::StartAsyncReplicationRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  *request.mutable_region_disks_start_async_replication_request_resource() =
      region_disks_start_async_replication_request_resource;
  return connection_->StartAsyncReplication(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StartAsyncReplication(
    google::cloud::cpp::compute::region_disks::v1::
        StartAsyncReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartAsyncReplication(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StopAsyncReplication(std::string const& project,
                                        std::string const& region,
                                        std::string const& disk, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::StopAsyncReplicationRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  return connection_->StopAsyncReplication(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StopAsyncReplication(
    google::cloud::cpp::compute::region_disks::v1::
        StopAsyncReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopAsyncReplication(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StopGroupAsyncReplication(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::
        DisksStopGroupAsyncReplicationResource const&
            disks_stop_group_async_replication_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::
      StopGroupAsyncReplicationRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_disks_stop_group_async_replication_resource() =
      disks_stop_group_async_replication_resource;
  return connection_->StopGroupAsyncReplication(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::StopGroupAsyncReplication(
    google::cloud::cpp::compute::region_disks::v1::
        StopGroupAsyncReplicationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopGroupAsyncReplication(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionDisksClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionDisksClient::TestIamPermissions(
    google::cloud::cpp::compute::region_disks::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::UpdateDisk(
    std::string const& project, std::string const& region,
    std::string const& disk, std::string const& update_mask,
    google::cloud::cpp::compute::v1::Disk const& disk_resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_disks::v1::UpdateDiskRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_disk(disk);
  request.set_update_mask(update_mask);
  *request.mutable_disk_resource() = disk_resource;
  return connection_->UpdateDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionDisksClient::UpdateDisk(
    google::cloud::cpp::compute::region_disks::v1::UpdateDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDisk(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_disks_v1
}  // namespace cloud
}  // namespace google
