#!/usr/bin/perl
# lang.cgi - This will test the HTMLObject Normal object Internationalization support.

use HTMLObject::Base;
use HTMLObject::Normal;
use HTMLObject::CGILib;
use strict;
#use cgi_lib;

use vars '%input';
my $doc = HTMLObject::Normal->new();

# Strings to internationalize.
my %Phrases = {};
# Source the default Language file so we have Phrases available regardless.
if (! -e "en_lang.pm")
{
  $doc->setTitle("Error:  HTMLObject Version ($HTMLObject::Normal::VERSION) - English Language file not found!");
  $doc->setFocus("body");
  $doc->print("<center><h1>English Language file not found!</h1></center>");
  $doc->display();
  exit 1;
}
eval `cat en_lang.pm`;

# get the values being passed in from the client
%input = ();  # make sure it is empty!
#cgi_lib::ReadParse(*input);
HTMLObject::CGILib::ReadParse(*input);

$doc->setLinkDecorations();

if (exists $input{'language'})
{ # display the page with the specific language.
  if (exists $input{'charEncoding'})
  {
    my $language = $input{'language'};
    my $charEncoding = $input{'charEncoding'};
    my $file = "$language" . "_lang.pm";
    
    if (! -e $file)
    {
      $doc->setTitle("Error:  HTMLObject Version ($HTMLObject::Normal::VERSION) - " . $doc->getLanguageName() . " Language file not found!");
      $doc->setFocus("body");
      $doc->print("<center><h1>" . $doc->getLanguageName() . " Language file not found!</h1></center>");
      $doc->display();
      exit 1;
    }
    $doc->setLanguageEncoding(language => $language, encoding => $charEncoding);
    eval `cat $file`;
    displayMainPage();
  }
  else
  { # error! char_encoding required.
    $doc->setTitle("$Phrases{'Error: '}$Phrases{'HTMLObject Version ('}$HTMLObject::Normal::VERSION$Phrases{') - Internationalization Test Page'}");
    $doc->setFocus("body");
    $doc->print(<<"END_OF_CODE");
    <center>
    <h1>$Phrases{'charEncoding required!'}</h1>
    $Phrases{'HTMLObject Version ('}$HTMLObject::Normal::VERSION$Phrases{') - Internationalization Test Page'}
    <br>
    $Phrases{'Press Back to return to the previous page.'}
END_OF_CODE
  }
}
else
{ # display the main page, default to english.
  displayMainPage();
}

$doc->display();

exit 0;

sub displayMainPage
{
  generateJavascript();  # build the JavaScript stuff we need.
  my $currLanguageName = $doc->getLanguageName();
  my $currLanguage = $doc->getLanguage();
  my $passedInString = "";
  my $russianString = "'ru' = '" . $doc->lookupLanguageName(code => 'ru') . "'";
  
  if (exists $input{'language'} && exists $input{'charEncoding'})
  {
    my $charEncoding = $doc->getCharEncoding();
    $passedInString = "$Phrases{'User Specified'}$Phrases{'Language = '}'$currLanguage'.&nbsp;$Phrases{'Character Encoding = '}'$charEncoding'";
  }
  
  $doc->setFocus("body");
  $doc->setTitle("$Phrases{'HTMLObject Version ('}$HTMLObject::Normal::VERSION$Phrases{') - Internationalization Test Page'}");
  $doc->print(<<"END_OF_CODE");
  <center>
  <h1>$Phrases{'Welcome'}</h1>
  $Phrases{'HTMLObject Version ('}$HTMLObject::Normal::VERSION$Phrases{') - Internationalization Test Page'}
  <br>
  $Phrases{'Current Language = '}"$currLanguageName"
  <br>
  $passedInString
  <br>
  $russianString
  <br>
  <form name="selectLang" method="post">
  <table border=0 width=50% align=center bgcolor="red">
    <tr>
      <td align=right><font color="white">$Phrases{'Select Language'}</font></td>
      <td align=left>
        <select name="language" onChange="updateCharset()">
          <option value="en">English
          <option value="eu">Basque
        </select>
      </td>
    </tr>
    <tr>
      <td align=right><font color="white">$Phrases{'Select Character Encoding'}</font></td>
      <td align=left>
        <select name="charEncoding">
          <option value="----">----
        </select>
      </td>
    </tr>
  </table>
  <input type=submit name="submit" value="$Phrases{'Submit'}">&nbsp;<input type=button name="resetButton" value="$Phrases{'Reset'}" onClick="resetForm()">
  </form>
  </center>
END_OF_CODE
  
  $doc->setOnload(code => "init()");  # cause the init function to be run when the page is loaded.
}

sub generateJavascript
{
  $doc->setFocus("javascript");
  $doc->print(<<"END_OF_CODE");
  function encoding(type1, type2)
  { // support up to 2 charset encodings for each language.
    this.type1 = type1;
    this.type2 = type2;
  }
  
  function init()
  {
    var d = document.selectLang;
    d.language.selectedIndex = 0;
    updateCharset();
  }
  
  function resetForm()
  {
    var d = document.selectLang;
    
    d.reset();  // reset the form.
    setTimeout("updateCharset();", 10);  // Update the Charset encoding in 10 milliseconds.
  }
  
  var codeToEncoding = new Array();
  codeToEncoding['en'] = new encoding('iso-8859-1', '');
  codeToEncoding['eu'] = new encoding('iso-8859-1', 'windows-1252');
  
  function updateCharset()
  {
    var d = document.selectLang;
    
    if (d.language.selectedIndex == -1)
    {
      alert("$Phrases{'You must select a Language!'}");
      return;
    }
    var value = d.language.options[d.language.selectedIndex].value;
    if (typeof codeToEncoding[value] == "undefined")
    {
      alert("$Phrases{'Invalid Language!'}");
      return;
    }
    else
    {
      var type1 = codeToEncoding[value].type1;
      var type2 = codeToEncoding[value].type2;
      
      d.charEncoding.options.length = 0;  // Clear the Character Encoding select box.
      d.charEncoding.options[0] = new Option(type1, type1);
      if (type2.length > 0)
      {
        d.charEncoding.options[1] = new Option(type2, type2);
      }
      d.charEncoding.selectedIndex = 0;
    }
  }
END_OF_CODE
}
