/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IdentityImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.PluginAttributeImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;

class PluginDescriptorImpl
extends IdentityImpl
implements PluginDescriptor {
    private final PluginRegistry registry;
    private final URL location;
    private final ModelPluginDescriptor model;
    private Map pluginPrerequisites;
    private Map libraries;
    private Map extensionPoints;
    private Map extensions;
    private Documentation doc;
    private List fragments;
    private List attributes;

    PluginDescriptorImpl(PluginRegistry pluginRegistry, ModelPluginDescriptor modelPluginDescriptor, URL uRL) throws ManifestProcessingException {
        super(modelPluginDescriptor.getId());
        this.registry = pluginRegistry;
        this.model = modelPluginDescriptor;
        this.location = uRL;
        if (this.model.getVendor() == null) {
            this.model.setVendor("");
        }
        if (this.model.getClassName() != null && this.model.getClassName().trim().length() == 0) {
            this.model.setClassName(null);
        }
        if (this.model.getDocsPath() == null || this.model.getDocsPath().trim().length() == 0) {
            this.model.setDocsPath("docs");
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl(this, this.model.getDocumentation());
        }
        this.attributes = new LinkedList();
        this.fragments = new LinkedList();
        this.pluginPrerequisites = new HashMap();
        this.libraries = new HashMap();
        this.extensionPoints = new HashMap();
        this.extensions = new HashMap();
        this.processAttributes(null, this.model);
        this.processPrerequisites(null, this.model);
        this.processLibraries(null, this.model);
        this.processExtensionPoints(null, this.model);
        this.processExtensions(null, this.model);
        this.log.debug("object instantiated: " + this);
    }

    void registerFragment(PluginFragmentImpl pluginFragmentImpl) throws ManifestProcessingException {
        this.fragments.add(pluginFragmentImpl);
        this.processAttributes(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processPrerequisites(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processLibraries(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processExtensionPoints(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processExtensions(pluginFragmentImpl, pluginFragmentImpl.getModel());
    }

    void unregisterFragment(PluginFragmentImpl pluginFragmentImpl) {
        Map.Entry entry;
        Iterator<Object> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            if (!pluginFragmentImpl.equals(((PluginAttribute)iterator.next()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.pluginPrerequisites.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((PluginPrerequisite)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.libraries.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((Library)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.extensionPoints.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((ExtensionPoint)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.extensions.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((Extension)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        this.fragments.remove(pluginFragmentImpl);
    }

    private void processAttributes(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        Iterator iterator = modelPluginManifest.getAttributes().iterator();
        while (iterator.hasNext()) {
            this.attributes.add(new PluginAttributeImpl(this, pluginFragmentImpl, (ModelAttribute)iterator.next(), null));
        }
    }

    private void processPrerequisites(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        Iterator iterator = modelPluginManifest.getPrerequisites().iterator();
        while (iterator.hasNext()) {
            PluginPrerequisiteImpl pluginPrerequisiteImpl = new PluginPrerequisiteImpl(this, pluginFragmentImpl, (ModelPrerequisite)iterator.next());
            if (this.pluginPrerequisites.containsKey(pluginPrerequisiteImpl.getPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateImports", new Object[]{pluginPrerequisiteImpl.getPluginId(), this.getId()});
            }
            this.pluginPrerequisites.put(pluginPrerequisiteImpl.getPluginId(), pluginPrerequisiteImpl);
        }
    }

    private void processLibraries(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        Iterator iterator = modelPluginManifest.getLibraries().iterator();
        while (iterator.hasNext()) {
            LibraryImpl libraryImpl = new LibraryImpl(this, pluginFragmentImpl, (ModelLibrary)iterator.next());
            if (this.libraries.containsKey(libraryImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateLibraries", new Object[]{libraryImpl.getId(), this.getId()});
            }
            this.libraries.put(libraryImpl.getId(), libraryImpl);
        }
    }

    private void processExtensionPoints(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        Iterator iterator = modelPluginManifest.getExtensionPoints().iterator();
        while (iterator.hasNext()) {
            ExtensionPointImpl extensionPointImpl = new ExtensionPointImpl(this, pluginFragmentImpl, (ModelExtensionPoint)iterator.next());
            if (this.extensionPoints.containsKey(extensionPointImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensionPoints", new Object[]{extensionPointImpl.getId(), this.getId()});
            }
            this.extensionPoints.put(extensionPointImpl.getId(), extensionPointImpl);
        }
    }

    private void processExtensions(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        Iterator iterator = modelPluginManifest.getExtensions().iterator();
        while (iterator.hasNext()) {
            ExtensionImpl extensionImpl = new ExtensionImpl(this, pluginFragmentImpl, (ModelExtension)iterator.next());
            if (this.extensions.containsKey(extensionImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensions", new Object[]{extensionImpl.getId(), this.getId()});
            }
            if (!this.getId().equals(extensionImpl.getExtendedPluginId()) && !this.pluginPrerequisites.containsKey(extensionImpl.getExtendedPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "pluginNotDeclaredInPrerequisites", new Object[]{extensionImpl.getExtendedPluginId(), extensionImpl.getId(), this.getId()});
            }
            this.extensions.put(extensionImpl.getId(), extensionImpl);
        }
    }

    public String getUniqueId() {
        return this.registry.makeUniqueId(this.getId(), this.model.getVersion());
    }

    public String getVendor() {
        return this.model.getVendor();
    }

    public Version getVersion() {
        return this.model.getVersion();
    }

    public Collection getPrerequisites() {
        return Collections.unmodifiableCollection(this.pluginPrerequisites.values());
    }

    public PluginPrerequisite getPrerequisite(String string) {
        return (PluginPrerequisite)this.pluginPrerequisites.get(string);
    }

    public Collection getExtensionPoints() {
        return Collections.unmodifiableCollection(this.extensionPoints.values());
    }

    public ExtensionPoint getExtensionPoint(String string) {
        return (ExtensionPoint)this.extensionPoints.get(string);
    }

    public Collection getExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    public Extension getExtension(String string) {
        return (Extension)this.extensions.get(string);
    }

    public Collection getLibraries() {
        return Collections.unmodifiableCollection(this.libraries.values());
    }

    public Library getLibrary(String string) {
        return (Library)this.libraries.get(string);
    }

    public PluginRegistry getRegistry() {
        return this.registry;
    }

    public String getPluginClassName() {
        return this.model.getClassName();
    }

    public String toString() {
        return "{PluginDescriptor: uid=" + this.getUniqueId() + "}";
    }

    public Documentation getDocumentation() {
        return this.doc;
    }

    public Collection getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }

    public PluginAttribute getAttribute(String string) {
        PluginAttributeImpl pluginAttributeImpl = null;
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            PluginAttributeImpl pluginAttributeImpl2 = (PluginAttributeImpl)iterator.next();
            if (!pluginAttributeImpl2.getId().equals(string)) continue;
            if (pluginAttributeImpl == null) {
                pluginAttributeImpl = pluginAttributeImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one attribute with ID " + string + " defined in plug-in " + this.getUniqueId());
        }
        return pluginAttributeImpl;
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public Collection getAttributes(String string) {
        LinkedList<PluginAttributeImpl> linkedList = new LinkedList<PluginAttributeImpl>();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            PluginAttributeImpl pluginAttributeImpl = (PluginAttributeImpl)iterator.next();
            if (!pluginAttributeImpl.getId().equals(string)) continue;
            linkedList.add(pluginAttributeImpl);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public String getDocsPath() {
        return this.model.getDocsPath();
    }

    public URL getLocation() {
        return this.location;
    }

    protected boolean isEqualTo(Identity identity) {
        if (!(identity instanceof PluginDescriptorImpl)) {
            return false;
        }
        PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)identity;
        return this.getLocation().equals(pluginDescriptorImpl.getLocation()) && this.getUniqueId().equals(pluginDescriptorImpl.getUniqueId());
    }
}

