/*
  File: support.h

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef SUPPORT_H
#define SUPPORT_H

#ifndef BOOTCREATOR_H
#include "bootcreator.h"
#endif /* BOOTCREATOR_H */

/*
 * bool
 */

#ifndef bool
typedef char bool;
#endif							/* bool */

#ifndef true
#define true 1
#endif							/* true */

#ifndef false
#define false 0
#endif							/* false */

/*
 * bcvar
 */

struct bcvar
{
	char var[FILE_BUF_SIZE];	/* variable */
	char val[FILE_BUF_SIZE];	/* value */
};

/*
 * Prototypes
 */

char *to_upper(char *str);
int get_line(int fh, int limit, char *buf, int *stat_line, bool pure);
int save_line(int file, char *buffer, int size);
int load_i(const char *buf);
int load_b(const char *buf);
bool get_var(char *buf, struct bcvar *var);
int convert_case(int x);

#endif /* SUPPORT_H */
