// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v2/cloud_tpu.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TPU_V2_TPU_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TPU_V2_TPU_CONNECTION_H

#include "google/cloud/tpu/v2/internal/tpu_retry_traits.h"
#include "google/cloud/tpu/v2/tpu_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/tpu/v2/cloud_tpu.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace tpu_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `TpuConnection`.
class TpuRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<TpuRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `TpuConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TpuLimitedErrorCountRetryPolicy : public TpuRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit TpuLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  TpuLimitedErrorCountRetryPolicy(
      TpuLimitedErrorCountRetryPolicy&& rhs) noexcept
      : TpuLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  TpuLimitedErrorCountRetryPolicy(
      TpuLimitedErrorCountRetryPolicy const& rhs) noexcept
      : TpuLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TpuRetryPolicy> clone() const override {
    return std::make_unique<TpuLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TpuRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      tpu_v2_internal::TpuRetryTraits>
      impl_;
};

/**
 * A retry policy for `TpuConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TpuLimitedTimeRetryPolicy : public TpuRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit TpuLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  TpuLimitedTimeRetryPolicy(TpuLimitedTimeRetryPolicy&& rhs) noexcept
      : TpuLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  TpuLimitedTimeRetryPolicy(TpuLimitedTimeRetryPolicy const& rhs) noexcept
      : TpuLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TpuRetryPolicy> clone() const override {
    return std::make_unique<TpuLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TpuRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      tpu_v2_internal::TpuRetryTraits>
      impl_;
};

/**
 * The `TpuConnection` object for `TpuClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `TpuClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `TpuClient`.
 *
 * To create a concrete instance, see `MakeTpuConnection()`.
 *
 * For mocking, see `tpu_v2_mocks::MockTpuConnection`.
 */
class TpuConnection {
 public:
  virtual ~TpuConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::tpu::v2::Node> ListNodes(
      google::cloud::tpu::v2::ListNodesRequest request);

  virtual StatusOr<google::cloud::tpu::v2::Node> GetNode(
      google::cloud::tpu::v2::GetNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> CreateNode(
      google::cloud::tpu::v2::CreateNodeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateNode(
      NoAwaitTag, google::cloud::tpu::v2::CreateNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> CreateNode(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::tpu::v2::OperationMetadata>>
  DeleteNode(google::cloud::tpu::v2::DeleteNodeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteNode(
      NoAwaitTag, google::cloud::tpu::v2::DeleteNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::OperationMetadata>>
  DeleteNode(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> StopNode(
      google::cloud::tpu::v2::StopNodeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StopNode(
      NoAwaitTag, google::cloud::tpu::v2::StopNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> StopNode(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> StartNode(
      google::cloud::tpu::v2::StartNodeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StartNode(
      NoAwaitTag, google::cloud::tpu::v2::StartNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> StartNode(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> UpdateNode(
      google::cloud::tpu::v2::UpdateNodeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateNode(
      NoAwaitTag, google::cloud::tpu::v2::UpdateNodeRequest const& request);

  virtual future<StatusOr<google::cloud::tpu::v2::Node>> UpdateNode(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::tpu::v2::GenerateServiceIdentityResponse>
  GenerateServiceIdentity(
      google::cloud::tpu::v2::GenerateServiceIdentityRequest const& request);

  virtual StreamRange<google::cloud::tpu::v2::AcceleratorType>
  ListAcceleratorTypes(
      google::cloud::tpu::v2::ListAcceleratorTypesRequest request);

  virtual StatusOr<google::cloud::tpu::v2::AcceleratorType> GetAcceleratorType(
      google::cloud::tpu::v2::GetAcceleratorTypeRequest const& request);

  virtual StreamRange<google::cloud::tpu::v2::RuntimeVersion>
  ListRuntimeVersions(
      google::cloud::tpu::v2::ListRuntimeVersionsRequest request);

  virtual StatusOr<google::cloud::tpu::v2::RuntimeVersion> GetRuntimeVersion(
      google::cloud::tpu::v2::GetRuntimeVersionRequest const& request);

  virtual StatusOr<google::cloud::tpu::v2::GetGuestAttributesResponse>
  GetGuestAttributes(
      google::cloud::tpu::v2::GetGuestAttributesRequest const& request);
};

/**
 * A factory function to construct an object of type `TpuConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of TpuClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `TpuConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::tpu_v2::TpuPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `TpuConnection` created by
 * this function.
 */
std::shared_ptr<TpuConnection> MakeTpuConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TPU_V2_TPU_CONNECTION_H
