// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_MOCKS_MOCK_SECURITY_CENTER_MANAGEMENT_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_MOCKS_MOCK_SECURITY_CENTER_MANAGEMENT_CONNECTION_H

#include "google/cloud/securitycentermanagement/v1/security_center_management_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `SecurityCenterManagementConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `SecurityCenterManagementClient`. To
 * do so, construct an object of type `SecurityCenterManagementClient` with an
 * instance of this class. Then use the Google Test framework functions to
 * program the behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockSecurityCenterManagementConnection
    : public securitycentermanagement_v1::SecurityCenterManagementConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::securitycentermanagement::v1::
                       EffectiveSecurityHealthAnalyticsCustomModule>),
      ListEffectiveSecurityHealthAnalyticsCustomModules,
      (google::cloud::securitycentermanagement::v1::
           ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::securitycentermanagement::v1::
                           EffectiveSecurityHealthAnalyticsCustomModule>,
              GetEffectiveSecurityHealthAnalyticsCustomModule,
              (google::cloud::securitycentermanagement::v1::
                   GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const&
                       request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::securitycentermanagement::v1::
                               SecurityHealthAnalyticsCustomModule>),
              ListSecurityHealthAnalyticsCustomModules,
              (google::cloud::securitycentermanagement::v1::
                   ListSecurityHealthAnalyticsCustomModulesRequest request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::securitycentermanagement::v1::
                       SecurityHealthAnalyticsCustomModule>),
      ListDescendantSecurityHealthAnalyticsCustomModules,
      (google::cloud::securitycentermanagement::v1::
           ListDescendantSecurityHealthAnalyticsCustomModulesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   SecurityHealthAnalyticsCustomModule>,
      GetSecurityHealthAnalyticsCustomModule,
      (google::cloud::securitycentermanagement::v1::
           GetSecurityHealthAnalyticsCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   SecurityHealthAnalyticsCustomModule>,
      CreateSecurityHealthAnalyticsCustomModule,
      (google::cloud::securitycentermanagement::v1::
           CreateSecurityHealthAnalyticsCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   SecurityHealthAnalyticsCustomModule>,
      UpdateSecurityHealthAnalyticsCustomModule,
      (google::cloud::securitycentermanagement::v1::
           UpdateSecurityHealthAnalyticsCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteSecurityHealthAnalyticsCustomModule,
      (google::cloud::securitycentermanagement::v1::
           DeleteSecurityHealthAnalyticsCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   SimulateSecurityHealthAnalyticsCustomModuleResponse>,
      SimulateSecurityHealthAnalyticsCustomModule,
      (google::cloud::securitycentermanagement::v1::
           SimulateSecurityHealthAnalyticsCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::securitycentermanagement::v1::
                       EffectiveEventThreatDetectionCustomModule>),
      ListEffectiveEventThreatDetectionCustomModules,
      (google::cloud::securitycentermanagement::v1::
           ListEffectiveEventThreatDetectionCustomModulesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   EffectiveEventThreatDetectionCustomModule>,
      GetEffectiveEventThreatDetectionCustomModule,
      (google::cloud::securitycentermanagement::v1::
           GetEffectiveEventThreatDetectionCustomModuleRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::securitycentermanagement::v1::
                               EventThreatDetectionCustomModule>),
              ListEventThreatDetectionCustomModules,
              (google::cloud::securitycentermanagement::v1::
                   ListEventThreatDetectionCustomModulesRequest request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::securitycentermanagement::v1::
                       EventThreatDetectionCustomModule>),
      ListDescendantEventThreatDetectionCustomModules,
      (google::cloud::securitycentermanagement::v1::
           ListDescendantEventThreatDetectionCustomModulesRequest request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::securitycentermanagement::v1::
                           EventThreatDetectionCustomModule>,
              GetEventThreatDetectionCustomModule,
              (google::cloud::securitycentermanagement::v1::
                   GetEventThreatDetectionCustomModuleRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   EventThreatDetectionCustomModule>,
      CreateEventThreatDetectionCustomModule,
      (google::cloud::securitycentermanagement::v1::
           CreateEventThreatDetectionCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   EventThreatDetectionCustomModule>,
      UpdateEventThreatDetectionCustomModule,
      (google::cloud::securitycentermanagement::v1::
           UpdateEventThreatDetectionCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteEventThreatDetectionCustomModule,
      (google::cloud::securitycentermanagement::v1::
           DeleteEventThreatDetectionCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::securitycentermanagement::v1::
                   ValidateEventThreatDetectionCustomModuleResponse>,
      ValidateEventThreatDetectionCustomModule,
      (google::cloud::securitycentermanagement::v1::
           ValidateEventThreatDetectionCustomModuleRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::securitycentermanagement::v1::SecurityCenterService>,
      GetSecurityCenterService,
      (google::cloud::securitycentermanagement::v1::
           GetSecurityCenterServiceRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::securitycentermanagement::v1::SecurityCenterService>),
      ListSecurityCenterServices,
      (google::cloud::securitycentermanagement::v1::
           ListSecurityCenterServicesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::securitycentermanagement::v1::SecurityCenterService>,
      UpdateSecurityCenterService,
      (google::cloud::securitycentermanagement::v1::
           UpdateSecurityCenterServiceRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_MOCKS_MOCK_SECURITY_CENTER_MANAGEMENT_CONNECTION_H
