// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_MOCKS_MOCK_OS_CONFIG_ZONAL_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_MOCKS_MOCK_OS_CONFIG_ZONAL_CONNECTION_H

#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace osconfig_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `OsConfigZonalServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `OsConfigZonalServiceClient`. To do
 * so, construct an object of type `OsConfigZonalServiceClient` with an instance
 * of this class. Then use the Google Test framework functions to program the
 * behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockOsConfigZonalServiceConnection
    : public osconfig_v1::OsConfigZonalServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateOSPolicyAssignment(Matcher<google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>,
      CreateOSPolicyAssignment,
      (google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateOSPolicyAssignment(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateOSPolicyAssignment,
      (NoAwaitTag,
       google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateOSPolicyAssignment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>,
              CreateOSPolicyAssignment,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateOSPolicyAssignment(Matcher<google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>,
      UpdateOSPolicyAssignment,
      (google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateOSPolicyAssignment(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateOSPolicyAssignment,
      (NoAwaitTag,
       google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateOSPolicyAssignment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>,
              UpdateOSPolicyAssignment,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>,
              GetOSPolicyAssignment,
              (google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>),
      ListOSPolicyAssignments,
      (google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>),
      ListOSPolicyAssignmentRevisions,
      (google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteOSPolicyAssignment(Matcher<google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>,
      DeleteOSPolicyAssignment,
      (google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteOSPolicyAssignment(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteOSPolicyAssignment,
      (NoAwaitTag,
       google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteOSPolicyAssignment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>,
      DeleteOSPolicyAssignment,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>,
      GetOSPolicyAssignmentReport,
      (google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>),
      ListOSPolicyAssignmentReports,
      (google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::osconfig::v1::Inventory>, GetInventory,
              (google::cloud::osconfig::v1::GetInventoryRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::osconfig::v1::Inventory>),
              ListInventories,
              (google::cloud::osconfig::v1::ListInventoriesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>,
              GetVulnerabilityReport,
              (google::cloud::osconfig::v1::GetVulnerabilityReportRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>),
      ListVulnerabilityReports,
      (google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_MOCKS_MOCK_OS_CONFIG_ZONAL_CONNECTION_H
