// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/language/v2/language_service.proto

#include "google/cloud/language/v2/language_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace language_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

LanguageServiceConnectionIdempotencyPolicy::
    ~LanguageServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<LanguageServiceConnectionIdempotencyPolicy>
LanguageServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<LanguageServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency LanguageServiceConnectionIdempotencyPolicy::AnalyzeSentiment(
    google::cloud::language::v2::AnalyzeSentimentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LanguageServiceConnectionIdempotencyPolicy::AnalyzeEntities(
    google::cloud::language::v2::AnalyzeEntitiesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LanguageServiceConnectionIdempotencyPolicy::ClassifyText(
    google::cloud::language::v2::ClassifyTextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LanguageServiceConnectionIdempotencyPolicy::ModerateText(
    google::cloud::language::v2::ModerateTextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LanguageServiceConnectionIdempotencyPolicy::AnnotateText(
    google::cloud::language::v2::AnnotateTextRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<LanguageServiceConnectionIdempotencyPolicy>
MakeDefaultLanguageServiceConnectionIdempotencyPolicy() {
  return std::make_unique<LanguageServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace language_v2
}  // namespace cloud
}  // namespace google
