// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/session_entity_type.proto

#include "google/cloud/dialogflow_cx/internal/session_entity_types_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/cx/v3/session_entity_type.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SessionEntityTypesStub::~SessionEntityTypesStub() = default;

StatusOr<google::cloud::dialogflow::cx::v3::ListSessionEntityTypesResponse>
DefaultSessionEntityTypesStub::ListSessionEntityTypes(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::ListSessionEntityTypesRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::ListSessionEntityTypesResponse response;
  auto status =
      grpc_stub_->ListSessionEntityTypes(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
DefaultSessionEntityTypesStub::GetSessionEntityType(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::GetSessionEntityTypeRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::SessionEntityType response;
  auto status = grpc_stub_->GetSessionEntityType(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
DefaultSessionEntityTypesStub::CreateSessionEntityType(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::CreateSessionEntityTypeRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::SessionEntityType response;
  auto status =
      grpc_stub_->CreateSessionEntityType(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
DefaultSessionEntityTypesStub::UpdateSessionEntityType(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::UpdateSessionEntityTypeRequest const&
        request) {
  google::cloud::dialogflow::cx::v3::SessionEntityType response;
  auto status =
      grpc_stub_->UpdateSessionEntityType(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultSessionEntityTypesStub::DeleteSessionEntityType(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::cx::v3::DeleteSessionEntityTypeRequest const&
        request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteSessionEntityType(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
