// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_instances/v1/region_instances.proto

#include "google/cloud/compute/region_instances/v1/region_instances_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instances_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionInstancesClient::RegionInstancesClient(
    std::shared_ptr<RegionInstancesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionInstancesClient::~RegionInstancesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstancesClient::BulkInsert(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::BulkInsertInstanceResource const&
        bulk_insert_instance_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_bulk_insert_instance_resource() =
      bulk_insert_instance_resource;
  return connection_->BulkInsert(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstancesClient::BulkInsert(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::BulkInsertInstanceResource const&
        bulk_insert_instance_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_bulk_insert_instance_resource() =
      bulk_insert_instance_resource;
  return connection_->BulkInsert(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstancesClient::BulkInsert(
    google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkInsert(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstancesClient::BulkInsert(
    NoAwaitTag,
    google::cloud::cpp::compute::region_instances::v1::BulkInsertRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkInsert(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstancesClient::BulkInsert(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkInsert(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instances_v1
}  // namespace cloud
}  // namespace google
