// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/backend_services/v1/backend_services.proto

#include "google/cloud/compute/backend_services/v1/backend_services_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_backend_services_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BackendServicesConnectionIdempotencyPolicy::
    ~BackendServicesConnectionIdempotencyPolicy() = default;

std::unique_ptr<BackendServicesConnectionIdempotencyPolicy>
BackendServicesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<BackendServicesConnectionIdempotencyPolicy>(*this);
}

Idempotency BackendServicesConnectionIdempotencyPolicy::AddSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        AddSignedUrlKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
BackendServicesConnectionIdempotencyPolicy::AggregatedListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        AggregatedListBackendServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::DeleteBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteBackendServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::DeleteSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteSignedUrlKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::GetBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        GetBackendServiceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::GetHealth(
    google::cloud::cpp::compute::backend_services::v1::
        GetHealthRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::GetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::InsertBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        InsertBackendServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::ListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        ListBackendServicesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::ListUsable(
    google::cloud::cpp::compute::backend_services::v1::
        ListUsableRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::PatchBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        PatchBackendServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::SetEdgeSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetEdgeSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::SetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetIamPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::SetSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::backend_services::v1::
        TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendServicesConnectionIdempotencyPolicy::UpdateBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        UpdateBackendServiceRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<BackendServicesConnectionIdempotencyPolicy>
MakeDefaultBackendServicesConnectionIdempotencyPolicy() {
  return std::make_unique<BackendServicesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_backend_services_v1
}  // namespace cloud
}  // namespace google
