// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/job.proto

#include "google/cloud/bigquerycontrol/v2/job_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceClient::JobServiceClient(
    std::shared_ptr<JobServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
JobServiceClient::~JobServiceClient() = default;

StatusOr<google::cloud::bigquery::v2::JobCancelResponse>
JobServiceClient::CancelJob(
    google::cloud::bigquery::v2::CancelJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelJob(request);
}

StatusOr<google::cloud::bigquery::v2::Job> JobServiceClient::GetJob(
    google::cloud::bigquery::v2::GetJobRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJob(request);
}

StatusOr<google::cloud::bigquery::v2::Job> JobServiceClient::InsertJob(
    google::cloud::bigquery::v2::InsertJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertJob(request);
}

Status JobServiceClient::DeleteJob(
    google::cloud::bigquery::v2::DeleteJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJob(request);
}

StreamRange<google::cloud::bigquery::v2::ListFormatJob>
JobServiceClient::ListJobs(google::cloud::bigquery::v2::ListJobsRequest request,
                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListJobs(std::move(request));
}

StatusOr<google::cloud::bigquery::v2::GetQueryResultsResponse>
JobServiceClient::GetQueryResults(
    google::cloud::bigquery::v2::GetQueryResultsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetQueryResults(request);
}

StatusOr<google::cloud::bigquery::v2::QueryResponse> JobServiceClient::Query(
    google::cloud::bigquery::v2::PostQueryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Query(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
