// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#include "google/cloud/aiplatform/v1/pipeline_connection.h"
#include "google/cloud/aiplatform/v1/internal/pipeline_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/pipeline_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/pipeline_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/pipeline_tracing_connection.h"
#include "google/cloud/aiplatform/v1/pipeline_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PipelineServiceConnection::~PipelineServiceConnection() = default;

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnection::CreateTrainingPipeline(
    google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnection::GetTrainingPipeline(
    google::cloud::aiplatform::v1::GetTrainingPipelineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnection::ListTrainingPipelines(
    google::cloud::aiplatform::v1::
        ListTrainingPipelinesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnection::DeleteTrainingPipeline(
    google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PipelineServiceConnection::DeleteTrainingPipeline(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnection::DeleteTrainingPipeline(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status PipelineServiceConnection::CancelTrainingPipeline(
    google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnection::CreatePipelineJob(
    google::cloud::aiplatform::v1::CreatePipelineJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnection::GetPipelineJob(
    google::cloud::aiplatform::v1::GetPipelineJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnection::ListPipelineJobs(
    google::cloud::aiplatform::v1::
        ListPipelineJobsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::PipelineJob>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnection::DeletePipelineJob(
    google::cloud::aiplatform::v1::DeletePipelineJobRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PipelineServiceConnection::DeletePipelineJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeletePipelineJobRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnection::DeletePipelineJob(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
PipelineServiceConnection::BatchDeletePipelineJobs(
    google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PipelineServiceConnection::BatchDeletePipelineJobs(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
PipelineServiceConnection::BatchDeletePipelineJobs(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status PipelineServiceConnection::CancelPipelineJob(
    google::cloud::aiplatform::v1::CancelPipelineJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
PipelineServiceConnection::BatchCancelPipelineJobs(
    google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PipelineServiceConnection::BatchCancelPipelineJobs(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
PipelineServiceConnection::BatchCancelPipelineJobs(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<PipelineServiceConnection> MakePipelineServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PipelineServicePolicyOptionList>(options,
                                                                  __func__);
  options = aiplatform_v1_internal::PipelineServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = aiplatform_v1_internal::CreateDefaultPipelineServiceStub(
      std::move(auth), options);
  return aiplatform_v1_internal::MakePipelineServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::PipelineServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
