// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/job_service.proto

#include "google/cloud/aiplatform/v1/job_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceClient::JobServiceClient(
    std::shared_ptr<JobServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
JobServiceClient::~JobServiceClient() = default;

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::CreateCustomJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::CustomJob const& custom_job, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateCustomJobRequest request;
  request.set_parent(parent);
  *request.mutable_custom_job() = custom_job;
  return connection_->CreateCustomJob(request);
}

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::CreateCustomJob(
    google::cloud::aiplatform::v1::CreateCustomJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCustomJob(request);
}

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::GetCustomJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetCustomJobRequest request;
  request.set_name(name);
  return connection_->GetCustomJob(request);
}

StatusOr<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::GetCustomJob(
    google::cloud::aiplatform::v1::GetCustomJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCustomJob(request);
}

StreamRange<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::ListCustomJobs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListCustomJobsRequest request;
  request.set_parent(parent);
  return connection_->ListCustomJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::CustomJob>
JobServiceClient::ListCustomJobs(
    google::cloud::aiplatform::v1::ListCustomJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCustomJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteCustomJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteCustomJobRequest request;
  request.set_name(name);
  return connection_->DeleteCustomJob(request);
}

StatusOr<google::longrunning::Operation> JobServiceClient::DeleteCustomJob(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteCustomJobRequest request;
  request.set_name(name);
  return connection_->DeleteCustomJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteCustomJob(
    google::cloud::aiplatform::v1::DeleteCustomJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCustomJob(request);
}

StatusOr<google::longrunning::Operation> JobServiceClient::DeleteCustomJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteCustomJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCustomJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteCustomJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCustomJob(operation);
}

Status JobServiceClient::CancelCustomJob(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelCustomJobRequest request;
  request.set_name(name);
  return connection_->CancelCustomJob(request);
}

Status JobServiceClient::CancelCustomJob(
    google::cloud::aiplatform::v1::CancelCustomJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelCustomJob(request);
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::CreateDataLabelingJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::DataLabelingJob const& data_labeling_job,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateDataLabelingJobRequest request;
  request.set_parent(parent);
  *request.mutable_data_labeling_job() = data_labeling_job;
  return connection_->CreateDataLabelingJob(request);
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::CreateDataLabelingJob(
    google::cloud::aiplatform::v1::CreateDataLabelingJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataLabelingJob(request);
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::GetDataLabelingJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetDataLabelingJobRequest request;
  request.set_name(name);
  return connection_->GetDataLabelingJob(request);
}

StatusOr<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::GetDataLabelingJob(
    google::cloud::aiplatform::v1::GetDataLabelingJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataLabelingJob(request);
}

StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::ListDataLabelingJobs(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListDataLabelingJobsRequest request;
  request.set_parent(parent);
  return connection_->ListDataLabelingJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::DataLabelingJob>
JobServiceClient::ListDataLabelingJobs(
    google::cloud::aiplatform::v1::ListDataLabelingJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataLabelingJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteDataLabelingJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest request;
  request.set_name(name);
  return connection_->DeleteDataLabelingJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteDataLabelingJob(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest request;
  request.set_name(name);
  return connection_->DeleteDataLabelingJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteDataLabelingJob(
    google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataLabelingJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteDataLabelingJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteDataLabelingJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataLabelingJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteDataLabelingJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataLabelingJob(operation);
}

Status JobServiceClient::CancelDataLabelingJob(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelDataLabelingJobRequest request;
  request.set_name(name);
  return connection_->CancelDataLabelingJob(request);
}

Status JobServiceClient::CancelDataLabelingJob(
    google::cloud::aiplatform::v1::CancelDataLabelingJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelDataLabelingJob(request);
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::CreateHyperparameterTuningJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::HyperparameterTuningJob const&
        hyperparameter_tuning_job,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateHyperparameterTuningJobRequest request;
  request.set_parent(parent);
  *request.mutable_hyperparameter_tuning_job() = hyperparameter_tuning_job;
  return connection_->CreateHyperparameterTuningJob(request);
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::CreateHyperparameterTuningJob(
    google::cloud::aiplatform::v1::CreateHyperparameterTuningJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHyperparameterTuningJob(request);
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::GetHyperparameterTuningJob(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetHyperparameterTuningJobRequest request;
  request.set_name(name);
  return connection_->GetHyperparameterTuningJob(request);
}

StatusOr<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::GetHyperparameterTuningJob(
    google::cloud::aiplatform::v1::GetHyperparameterTuningJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHyperparameterTuningJob(request);
}

StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::ListHyperparameterTuningJobs(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListHyperparameterTuningJobsRequest request;
  request.set_parent(parent);
  return connection_->ListHyperparameterTuningJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::HyperparameterTuningJob>
JobServiceClient::ListHyperparameterTuningJobs(
    google::cloud::aiplatform::v1::ListHyperparameterTuningJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHyperparameterTuningJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteHyperparameterTuningJob(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest request;
  request.set_name(name);
  return connection_->DeleteHyperparameterTuningJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteHyperparameterTuningJob(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest request;
  request.set_name(name);
  return connection_->DeleteHyperparameterTuningJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteHyperparameterTuningJob(
    google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHyperparameterTuningJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteHyperparameterTuningJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteHyperparameterTuningJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHyperparameterTuningJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteHyperparameterTuningJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHyperparameterTuningJob(operation);
}

Status JobServiceClient::CancelHyperparameterTuningJob(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelHyperparameterTuningJobRequest request;
  request.set_name(name);
  return connection_->CancelHyperparameterTuningJob(request);
}

Status JobServiceClient::CancelHyperparameterTuningJob(
    google::cloud::aiplatform::v1::CancelHyperparameterTuningJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelHyperparameterTuningJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NasJob> JobServiceClient::CreateNasJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::NasJob const& nas_job, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateNasJobRequest request;
  request.set_parent(parent);
  *request.mutable_nas_job() = nas_job;
  return connection_->CreateNasJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NasJob> JobServiceClient::CreateNasJob(
    google::cloud::aiplatform::v1::CreateNasJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNasJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NasJob> JobServiceClient::GetNasJob(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetNasJobRequest request;
  request.set_name(name);
  return connection_->GetNasJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NasJob> JobServiceClient::GetNasJob(
    google::cloud::aiplatform::v1::GetNasJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNasJob(request);
}

StreamRange<google::cloud::aiplatform::v1::NasJob>
JobServiceClient::ListNasJobs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListNasJobsRequest request;
  request.set_parent(parent);
  return connection_->ListNasJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::NasJob>
JobServiceClient::ListNasJobs(
    google::cloud::aiplatform::v1::ListNasJobsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNasJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteNasJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNasJobRequest request;
  request.set_name(name);
  return connection_->DeleteNasJob(request);
}

StatusOr<google::longrunning::Operation> JobServiceClient::DeleteNasJob(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNasJobRequest request;
  request.set_name(name);
  return connection_->DeleteNasJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteNasJob(
    google::cloud::aiplatform::v1::DeleteNasJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNasJob(request);
}

StatusOr<google::longrunning::Operation> JobServiceClient::DeleteNasJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNasJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNasJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteNasJob(google::longrunning::Operation const& operation,
                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNasJob(operation);
}

Status JobServiceClient::CancelNasJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelNasJobRequest request;
  request.set_name(name);
  return connection_->CancelNasJob(request);
}

Status JobServiceClient::CancelNasJob(
    google::cloud::aiplatform::v1::CancelNasJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelNasJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceClient::GetNasTrialDetail(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetNasTrialDetailRequest request;
  request.set_name(name);
  return connection_->GetNasTrialDetail(request);
}

StatusOr<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceClient::GetNasTrialDetail(
    google::cloud::aiplatform::v1::GetNasTrialDetailRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNasTrialDetail(request);
}

StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceClient::ListNasTrialDetails(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListNasTrialDetailsRequest request;
  request.set_parent(parent);
  return connection_->ListNasTrialDetails(request);
}

StreamRange<google::cloud::aiplatform::v1::NasTrialDetail>
JobServiceClient::ListNasTrialDetails(
    google::cloud::aiplatform::v1::ListNasTrialDetailsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNasTrialDetails(std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::CreateBatchPredictionJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::BatchPredictionJob const&
        batch_prediction_job,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateBatchPredictionJobRequest request;
  request.set_parent(parent);
  *request.mutable_batch_prediction_job() = batch_prediction_job;
  return connection_->CreateBatchPredictionJob(request);
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::CreateBatchPredictionJob(
    google::cloud::aiplatform::v1::CreateBatchPredictionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBatchPredictionJob(request);
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::GetBatchPredictionJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetBatchPredictionJobRequest request;
  request.set_name(name);
  return connection_->GetBatchPredictionJob(request);
}

StatusOr<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::GetBatchPredictionJob(
    google::cloud::aiplatform::v1::GetBatchPredictionJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBatchPredictionJob(request);
}

StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::ListBatchPredictionJobs(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListBatchPredictionJobsRequest request;
  request.set_parent(parent);
  return connection_->ListBatchPredictionJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::BatchPredictionJob>
JobServiceClient::ListBatchPredictionJobs(
    google::cloud::aiplatform::v1::ListBatchPredictionJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBatchPredictionJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteBatchPredictionJob(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest request;
  request.set_name(name);
  return connection_->DeleteBatchPredictionJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteBatchPredictionJob(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest request;
  request.set_name(name);
  return connection_->DeleteBatchPredictionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteBatchPredictionJob(
    google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBatchPredictionJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteBatchPredictionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteBatchPredictionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBatchPredictionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteBatchPredictionJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBatchPredictionJob(operation);
}

Status JobServiceClient::CancelBatchPredictionJob(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelBatchPredictionJobRequest request;
  request.set_name(name);
  return connection_->CancelBatchPredictionJob(request);
}

Status JobServiceClient::CancelBatchPredictionJob(
    google::cloud::aiplatform::v1::CancelBatchPredictionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelBatchPredictionJob(request);
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::CreateModelDeploymentMonitoringJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
        model_deployment_monitoring_job,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateModelDeploymentMonitoringJobRequest
      request;
  request.set_parent(parent);
  *request.mutable_model_deployment_monitoring_job() =
      model_deployment_monitoring_job;
  return connection_->CreateModelDeploymentMonitoringJob(request);
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::CreateModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        CreateModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateModelDeploymentMonitoringJob(request);
}

StreamRange<google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>
JobServiceClient::SearchModelDeploymentMonitoringStatsAnomalies(
    std::string const& model_deployment_monitoring_job,
    std::string const& deployed_model_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::
      SearchModelDeploymentMonitoringStatsAnomaliesRequest request;
  request.set_model_deployment_monitoring_job(model_deployment_monitoring_job);
  request.set_deployed_model_id(deployed_model_id);
  return connection_->SearchModelDeploymentMonitoringStatsAnomalies(request);
}

StreamRange<google::cloud::aiplatform::v1::ModelMonitoringStatsAnomalies>
JobServiceClient::SearchModelDeploymentMonitoringStatsAnomalies(
    google::cloud::aiplatform::v1::
        SearchModelDeploymentMonitoringStatsAnomaliesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchModelDeploymentMonitoringStatsAnomalies(
      std::move(request));
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::GetModelDeploymentMonitoringJob(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetModelDeploymentMonitoringJobRequest request;
  request.set_name(name);
  return connection_->GetModelDeploymentMonitoringJob(request);
}

StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::GetModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::GetModelDeploymentMonitoringJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetModelDeploymentMonitoringJob(request);
}

StreamRange<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::ListModelDeploymentMonitoringJobs(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListModelDeploymentMonitoringJobsRequest
      request;
  request.set_parent(parent);
  return connection_->ListModelDeploymentMonitoringJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>
JobServiceClient::ListModelDeploymentMonitoringJobs(
    google::cloud::aiplatform::v1::ListModelDeploymentMonitoringJobsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListModelDeploymentMonitoringJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
JobServiceClient::UpdateModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
        model_deployment_monitoring_job,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateModelDeploymentMonitoringJobRequest
      request;
  *request.mutable_model_deployment_monitoring_job() =
      model_deployment_monitoring_job;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateModelDeploymentMonitoringJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::UpdateModelDeploymentMonitoringJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob const&
        model_deployment_monitoring_job,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateModelDeploymentMonitoringJobRequest
      request;
  *request.mutable_model_deployment_monitoring_job() =
      model_deployment_monitoring_job;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateModelDeploymentMonitoringJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
JobServiceClient::UpdateModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        UpdateModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateModelDeploymentMonitoringJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::UpdateModelDeploymentMonitoringJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::
        UpdateModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateModelDeploymentMonitoringJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::ModelDeploymentMonitoringJob>>
JobServiceClient::UpdateModelDeploymentMonitoringJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateModelDeploymentMonitoringJob(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteModelDeploymentMonitoringJob(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteModelDeploymentMonitoringJobRequest
      request;
  request.set_name(name);
  return connection_->DeleteModelDeploymentMonitoringJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteModelDeploymentMonitoringJob(NoAwaitTag,
                                                     std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteModelDeploymentMonitoringJobRequest
      request;
  request.set_name(name);
  return connection_->DeleteModelDeploymentMonitoringJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        DeleteModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModelDeploymentMonitoringJob(request);
}

StatusOr<google::longrunning::Operation>
JobServiceClient::DeleteModelDeploymentMonitoringJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::
        DeleteModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModelDeploymentMonitoringJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
JobServiceClient::DeleteModelDeploymentMonitoringJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteModelDeploymentMonitoringJob(operation);
}

Status JobServiceClient::PauseModelDeploymentMonitoringJob(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::PauseModelDeploymentMonitoringJobRequest
      request;
  request.set_name(name);
  return connection_->PauseModelDeploymentMonitoringJob(request);
}

Status JobServiceClient::PauseModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        PauseModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseModelDeploymentMonitoringJob(request);
}

Status JobServiceClient::ResumeModelDeploymentMonitoringJob(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ResumeModelDeploymentMonitoringJobRequest
      request;
  request.set_name(name);
  return connection_->ResumeModelDeploymentMonitoringJob(request);
}

Status JobServiceClient::ResumeModelDeploymentMonitoringJob(
    google::cloud::aiplatform::v1::
        ResumeModelDeploymentMonitoringJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeModelDeploymentMonitoringJob(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
