// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "generator/integration_tests/golden/v1/golden_kitchen_sink_connection_idempotency_policy.h"
#include <gmock/gmock.h>
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

using ::google::cloud::Idempotency;

class GoldenKitchenSinkIdempotencyPolicyTest : public ::testing::Test {
 protected:
  void SetUp() override {
    policy_ =
        golden_v1::MakeDefaultGoldenKitchenSinkConnectionIdempotencyPolicy();
  }

  std::unique_ptr<golden_v1::GoldenKitchenSinkConnectionIdempotencyPolicy>
      policy_;
};

TEST_F(GoldenKitchenSinkIdempotencyPolicyTest, GenerateAccessToken) {
  google::test::admin::database::v1::GenerateAccessTokenRequest request;
  EXPECT_EQ(policy_->GenerateAccessToken(request), Idempotency::kNonIdempotent);
}

TEST_F(GoldenKitchenSinkIdempotencyPolicyTest, GenerateIdToken) {
  google::test::admin::database::v1::GenerateIdTokenRequest request;
  EXPECT_EQ(policy_->GenerateIdToken(request), Idempotency::kNonIdempotent);
}

TEST_F(GoldenKitchenSinkIdempotencyPolicyTest, WriteLogEntries) {
  google::test::admin::database::v1::WriteLogEntriesRequest request;
  EXPECT_EQ(policy_->WriteLogEntries(request), Idempotency::kNonIdempotent);
}

TEST_F(GoldenKitchenSinkIdempotencyPolicyTest, ListLogs) {
  google::test::admin::database::v1::ListLogsRequest request;
  EXPECT_EQ(policy_->ListLogs(request), Idempotency::kNonIdempotent);
}

TEST_F(GoldenKitchenSinkIdempotencyPolicyTest, ListServiceAccountKeys) {
  google::test::admin::database::v1::ListServiceAccountKeysRequest request;
  EXPECT_EQ(policy_->ListServiceAccountKeys(request), Idempotency::kIdempotent);
}

}  // namespace
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
