/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.gui;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.XSBPeer;
import com.declarativa.interprolog.gui.PredicateTableModel;
import com.declarativa.interprolog.gui.TermListModel;
import com.declarativa.interprolog.gui.TermTreeModel;
import com.declarativa.interprolog.gui.XSBTableModel;
import com.declarativa.interprolog.util.IPException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class ListenerWindow
extends JFrame
implements WindowListener {
    public JTextArea prologOutput;
    public JTextArea prologInput;
    JMenu historyMenu;
    JMenu fileMenu;
    Vector loadedFiles;
    private static int topLevelCount = 0;
    public AbstractPrologEngine engine = null;
    public static boolean debug = false;
    public static String prologStartCommand = null;
    public static boolean loadFromJar = true;
    static /* synthetic */ Class class$com$declarativa$interprolog$gui$ListenerWindow;

    public ListenerWindow(AbstractPrologEngine abstractPrologEngine) {
        this(abstractPrologEngine, true);
    }

    public ListenerWindow(AbstractPrologEngine abstractPrologEngine, boolean bl) {
        super("PrologEngine listener (Swing)");
        if (abstractPrologEngine == null) {
            throw new IPException("missing Prolog engine");
        }
        this.engine = abstractPrologEngine;
        String string = abstractPrologEngine.getImplementationPeer().visualizationFilename();
        if (this.engine.getLoadFromJar()) {
            this.engine.consultFromPackage(string, class$com$declarativa$interprolog$gui$ListenerWindow != null ? class$com$declarativa$interprolog$gui$ListenerWindow : (class$com$declarativa$interprolog$gui$ListenerWindow = ListenerWindow.class$("com.declarativa.interprolog.gui.ListenerWindow")));
        } else {
            this.engine.consultRelative(string, class$com$declarativa$interprolog$gui$ListenerWindow != null ? class$com$declarativa$interprolog$gui$ListenerWindow : (class$com$declarativa$interprolog$gui$ListenerWindow = ListenerWindow.class$("com.declarativa.interprolog.gui.ListenerWindow")));
        }
        this.engine.teachMoreObjects(ListenerWindow.guiExamples());
        if (this.engine == null) {
            this.dispose();
        } else {
            ++topLevelCount;
        }
        debug = this.engine.isDebug();
        this.loadedFiles = new Vector();
        this.constructWindowContents();
        this.constructMenu();
        this.addWindowListener(this);
        this.prologInput.addKeyListener(new 1());
        this.prologOutput.append("Welcome to an InterProlog top level\n" + abstractPrologEngine.getPrologVersion() + "\n\n");
        if (bl) {
            ((Component)this).setVisible(true);
            this.focusInput();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.engine.shutdown();
        if (--topLevelCount <= 0) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.prologInput.requestFocus();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public static ObjectExamplePair[] guiExamples() {
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[]{PredicateTableModel.example(), TermListModel.example(), TermTreeModel.example(), new ObjectExamplePair("ArrayOfTermTreeModel", (Object)new TermTreeModel[0]), XSBTableModel.example()};
        return objectExamplePairArray;
    }

    void constructWindowContents() {
        Font font = new Font("Courier", 0, 12);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.prologOutput = new JTextArea(20, 80);
        this.prologOutput.setFont(font);
        this.prologOutput.setEditable(false);
        this.prologOutput.setToolTipText("Here's Prolog console output");
        this.prologOutput.setLineWrap(true);
        this.prologOutput.setDoubleBuffered(true);
        this.prologOutput.getAccessibleContext().setAccessibleName("Prolog Console Output");
        JScrollPane jScrollPane = new JScrollPane();
        this.prologInput = new JTextArea(4, 80);
        this.prologInput.setFont(font);
        this.prologInput.setLineWrap(true);
        this.prologInput.setToolTipText("Prolog input, sent when you press enter. Drag and drop .P files here to reconsult them");
        this.prologInput.getAccessibleContext().setAccessibleName("Prolog Input");
        jScrollPane.getViewport().add(this.prologInput);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.prologOutput);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, this.prologInput);
        container.add("Center", jSplitPane);
        ((Component)this).setSize(600, 600);
        jSplitPane.setDividerLocation(500);
        this.validate();
        2 var6_6 = new 2();
        new DropTarget(this.prologInput, var6_6);
    }

    void handlePrologInputDnD(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            int n = dropTargetDropEvent.getDropAction();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                if (this.engine.isIdle()) {
                    Object object;
                    dropTargetDropEvent.acceptDrop(n);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < list.size()) {
                        object = ((File)list.get(n2)).getName();
                        int n3 = ((String)object).lastIndexOf(46);
                        if (!((String)object).endsWith(".P")) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        this.errorMessage("All dragged files must be Prolog source files (with a .P extension)");
                    } else {
                        this.prologOutput.append("\nReconsulting " + (list.size() > 1 ? String.valueOf(list.size()) + " files...\n" : String.valueOf(list.size()) + " file...\n"));
                        object = new 3(list, this);
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                    this.errorMessage("You can not consult files while Prolog is working");
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            throw new IPException("Problem dropping:" + exception);
        }
    }

    public boolean processDraggedFile(File file) {
        if (this.engine.consultAbsolute(file)) {
            this.addToReloaders(file, "consult");
            return true;
        }
        this.errorMessage("Problems reconsulting " + file.getName());
        return false;
    }

    public void errorMessage(String string) {
        ListenerWindow.beep();
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    void constructMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        jMenuBar.add(this.fileMenu);
        ListenerWindow.addItemToMenu(this.fileMenu, "Consult...", 'C', new 4());
        if (this.engine.getImplementationPeer() instanceof XSBPeer) {
            ListenerWindow.addItemToMenu(this.fileMenu, "Load dynamically...", 'L', new 5());
        }
        this.fileMenu.addSeparator();
        JMenu jMenu = new JMenu("Tools");
        jMenu.setMnemonic('T');
        jMenuBar.add(jMenu);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Engine debugging");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new 6(jCheckBoxMenuItem, this));
        ListenerWindow.addItemToMenu(jMenu, "See Object Specifications", 'S', new 7());
        ListenerWindow.addItemToMenu(jMenu, "Interrupt Prolog", 'I', new 8());
        this.historyMenu = new JMenu("History", true);
        this.historyMenu.setMnemonic('H');
        jMenuBar.add(this.historyMenu);
        this.historyMenu.addSeparator();
    }

    static void addItemToMenu(JMenu jMenu, String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
    }

    static void addItemToMenu(JMenu jMenu, String string, char c, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setMnemonic(c);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
    }

    public abstract void sendToProlog();

    protected void addToHistory() {
        JMenuItem jMenuItem;
        String string = this.prologInput.getText();
        if (string.equals(";")) {
            return;
        }
        if (string.length() > 20) {
            jMenuItem = new JMenuItem(String.valueOf(string.substring(0, 19)) + "...");
            this.historyMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem(string.substring(0, string.length()));
            this.historyMenu.add(jMenuItem);
        }
        jMenuItem.addActionListener(new HistoryListener(this.prologInput, string));
    }

    void addToReloaders(File file, String string) {
        LoadedFile loadedFile = new LoadedFile(file, string);
        if (!this.loadedFiles.contains(loadedFile)) {
            this.loadedFiles.addElement(loadedFile);
            ListenerWindow.addItemToMenu(this.fileMenu, file.getName(), new 9(loadedFile, this));
        }
    }

    public boolean successfulCommand(String string) {
        try {
            return this.engine.command(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    void reconsultFile() {
        File file = null;
        FileDialog fileDialog = new FileDialog((Frame)this, "Consult file...");
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null && this.engine.consultAbsolute(file = new File(string2, string))) {
            this.addToReloaders(file, "consult");
        }
    }

    void load_dynFile() {
        File file = null;
        FileDialog fileDialog = new FileDialog((Frame)this, "load_dyn file...");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null && this.successfulCommand("load_dyn('" + this.engine.unescapedFilePath((file = new File(string2, string)).getAbsolutePath()) + "')")) {
            this.addToReloaders(file, "load_dyn");
        }
    }

    public void focusInput() {
        this.prologInput.selectAll();
        this.prologInput.requestFocus();
    }

    public void scrollToBottom() {
        block2: {
            if (!this.prologOutput.isShowing()) break block2;
            this.prologOutput.setCaretPosition(this.prologOutput.getDocument().getEndPosition().getOffset() - 1);
            try {
                JScrollBar jScrollBar = ((JScrollPane)((JViewport)this.prologOutput.getParent()).getParent()).getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMaximum());
                JScrollBar jScrollBar2 = ((JScrollPane)((JViewport)this.prologOutput.getParent()).getParent()).getHorizontalScrollBar();
                jScrollBar2.setValue(jScrollBar2.getMinimum());
            }
            catch (Exception exception) {}
        }
    }

    public static void commonMain(String[] stringArray) {
        ListenerWindow.commonGreeting();
        if (stringArray.length >= 1) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().startsWith("-d")) {
                    debug = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].toLowerCase().startsWith("-nojar")) {
                    loadFromJar = false;
                    ++n;
                    continue;
                }
                prologStartCommand = ListenerWindow.remainingArgs(stringArray, n);
                break;
            }
        } else {
            throw new IPException("Missing arguments in command line");
        }
    }

    public static void commonGreeting() {
        System.out.println("Welcome " + System.getProperty("user.name") + " to InterProlog " + "2.1.2" + " on Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + "), " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
    }

    public static String commandArgs(String[] stringArray) {
        return ListenerWindow.remainingArgs(stringArray, 0);
    }

    public static String remainingArgs(String[] stringArray, int n) {
        if (stringArray.length == 0) {
            throw new IPException("Missing arguments in command line");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < stringArray.length) {
            if (n2 > n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ListenerWindow.this.sendToProlog();
                keyEvent.consume();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements DropTargetListener {
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            ListenerWindow.this.handlePrologInputDnD(dropTargetDropEvent);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        /* synthetic */ 2() {
        }
    }

    private static final class 3
    implements Runnable {
        private final /* synthetic */ ListenerWindow this$0;
        private final /* synthetic */ List val$files;

        public void run() {
            boolean bl = false;
            Toolkit.getDefaultToolkit().sync();
            int n = 0;
            while (n < this.val$files.size() && !bl) {
                File file = (File)this.val$files.get(n);
                if (!this.this$0.processDraggedFile(file)) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.this$0.prologOutput.append("...terminated with errors.\n");
            } else {
                this.this$0.prologOutput.append("...done.\n");
            }
        }

        /* synthetic */ 3(List list, ListenerWindow listenerWindow) {
            this.val$files = list;
            this.this$0 = listenerWindow;
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ListenerWindow.this.reconsultFile();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ListenerWindow.this.load_dynFile();
        }

        /* synthetic */ 5() {
        }
    }

    private static final class 6
    implements ActionListener {
        private final /* synthetic */ JCheckBoxMenuItem val$debugging;
        private final /* synthetic */ ListenerWindow this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.engine.setDebug(this.val$debugging.isSelected());
        }

        /* synthetic */ 6(JCheckBoxMenuItem jCheckBoxMenuItem, ListenerWindow listenerWindow) {
            this.val$debugging = jCheckBoxMenuItem;
            this.this$0 = listenerWindow;
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ListenerWindow.this.engine.command("showObjectVariables");
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ListenerWindow.this.engine.interrupt();
        }

        /* synthetic */ 8() {
        }
    }

    class HistoryListener
    implements ActionListener {
        JTextComponent targetText;
        String memory;

        HistoryListener(JTextComponent jTextComponent, String string) {
            this.targetText = jTextComponent;
            this.memory = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.targetText.replaceSelection(this.memory);
        }
    }

    static class LoadedFile {
        File file;
        String method;

        LoadedFile(File file, String string) {
            this.file = file;
            this.method = string;
            if (!string.equals("consult") && !string.equals("load_dyn")) {
                throw new IPException("bad load method");
            }
        }

        public boolean equals(LoadedFile loadedFile) {
            return this.file.equals(loadedFile.file) && this.method.equals(loadedFile.method);
        }
    }

    private static final class 9
    implements ActionListener {
        private final /* synthetic */ LoadedFile val$lf;
        private final /* synthetic */ ListenerWindow this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.engine.command(String.valueOf(this.val$lf.method) + "('" + this.this$0.engine.unescapedFilePath(this.val$lf.file.getAbsolutePath()) + "')");
        }

        /* synthetic */ 9(LoadedFile loadedFile, ListenerWindow listenerWindow) {
            this.val$lf = loadedFile;
            this.this$0 = listenerWindow;
        }
    }
}

