// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogTargetLogForwardOKCode is the HTTP code returned for type GetLogTargetLogForwardOK
const GetLogTargetLogForwardOKCode int = 200

/*
GetLogTargetLogForwardOK Successful operation

swagger:response getLogTargetLogForwardOK
*/
type GetLogTargetLogForwardOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewGetLogTargetLogForwardOK creates GetLogTargetLogForwardOK with default headers values
func NewGetLogTargetLogForwardOK() *GetLogTargetLogForwardOK {

	return &GetLogTargetLogForwardOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target log forward o k response
func (o *GetLogTargetLogForwardOK) WithConfigurationVersion(configurationVersion string) *GetLogTargetLogForwardOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target log forward o k response
func (o *GetLogTargetLogForwardOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target log forward o k response
func (o *GetLogTargetLogForwardOK) WithPayload(payload *models.LogTarget) *GetLogTargetLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target log forward o k response
func (o *GetLogTargetLogForwardOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogTargetLogForwardNotFoundCode is the HTTP code returned for type GetLogTargetLogForwardNotFound
const GetLogTargetLogForwardNotFoundCode int = 404

/*
GetLogTargetLogForwardNotFound The specified resource was not found

swagger:response getLogTargetLogForwardNotFound
*/
type GetLogTargetLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetLogForwardNotFound creates GetLogTargetLogForwardNotFound with default headers values
func NewGetLogTargetLogForwardNotFound() *GetLogTargetLogForwardNotFound {

	return &GetLogTargetLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target log forward not found response
func (o *GetLogTargetLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *GetLogTargetLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target log forward not found response
func (o *GetLogTargetLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target log forward not found response
func (o *GetLogTargetLogForwardNotFound) WithPayload(payload *models.Error) *GetLogTargetLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target log forward not found response
func (o *GetLogTargetLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogTargetLogForwardDefault General Error

swagger:response getLogTargetLogForwardDefault
*/
type GetLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetLogForwardDefault creates GetLogTargetLogForwardDefault with default headers values
func NewGetLogTargetLogForwardDefault(code int) *GetLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) WithStatusCode(code int) *GetLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *GetLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) WithPayload(payload *models.Error) *GetLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target log forward default response
func (o *GetLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
