var buttonsClass = {
    new : func (device) {
        var m = { parents: [ buttonsClass ] };
        m.device = device;
        return m;
    },

    PAN : func (xdir = 0, ydir = 0) {
    },

    AsSwitchNAV : func {
        var n = getprop('/instrumentation/zkv1000/radios/nav-tune');
        var tmp = getprop('/instrumentation/nav[' ~ n ~ ']/frequencies/selected-mhz');
        setprop('/instrumentation/nav[' ~ n ~ ']/frequencies/selected-mhz', getprop('/instrumentation/nav[' ~ n ~ ']/frequencies/standby-mhz'));
        setprop('/instrumentation/nav[' ~ n ~ ']/frequencies/standby-mhz', tmp);
        foreach (var c; keys(flightdeck))
            if (contains(flightdeck[c], 'display'))
                flightdeck[c].display.updateNAV({refresh: n+1});
    },

    AsSwitchCOM : func (x) {
        if (x) {
            me.AsSwitchCOM_pushed = getprop('/sim/time/elapsed-sec');
        }
        else {
            var pressed = getprop('/sim/time/elapsed-sec') - me.AsSwitchCOM_pushed;
            if (pressed > 2) {
                setprop('/instrumentation/comm/frequencies/selected-mhz', 121.500);
                setprop('/instrumentation/zkv1000/radios/comm1-selected', 1);
                setprop('/instrumentation/zkv1000/radios/comm2-selected', 0);
                foreach (var d; keys(flightdeck))
                    if (contains(flightdeck[d], 'display')) {
                        flightdeck[d].display.updateCOMM({refresh: 1});
                        flightdeck[d].display.updateCOMM({refresh: 2});
                    }
            }
            else {
                var c = getprop('/instrumentation/zkv1000/radios/comm-tune');
                var tmp = getprop('/instrumentation/comm[' ~ c ~ ']/frequencies/selected-mhz');
                setprop('/instrumentation/comm[' ~ c ~ ']/frequencies/selected-mhz', getprop('/instrumentation/comm[' ~ c ~ ']/frequencies/standby-mhz'));
                setprop('/instrumentation/comm[' ~ c ~ ']/frequencies/standby-mhz', tmp);
                foreach (var d; keys(flightdeck))
                    if (contains(flightdeck[d], 'display'))
                        flightdeck[d].display.updateCOMM({refresh: c+1});
            }
        }
    },

    ALT : func () {
        var alt = getprop('instrumentation/altimeter/indicated-altitude-ft');
        setprop('/instrumentation/zkv1000/afcs/selected-alt-ft', math.round(alt, 10));
    },

    ValidateTMRREF : func (a = 0) {
        if (a)
            return;
        var (id, selected) = split('-', me.device.windows.selected);
        var state = me.device.windows.state[id];
        selected += state.scroll.offset;
        if (contains(state.objects[selected], 'callback'))
            call(state.objects[selected].callback, [id, selected], me);
    },

    ClearTMRREF : func (a = 0) {
        if (a)
            return;
        me.device.windows.del();
        me.device.data.TMRtimer = nil;
        me.device.knobs.FmsInner = func;
        me.device.knobs.FmsOuter = func;
        me.device.buttons.ENT = func;
        me.device.buttons.FMS = func;
        me.device.buttons.CLR = func;
    },

    MFD_page_wrapper : func (id, selected) {
        var s = me.device.data[id][me.device.display['page selected']];
        var group = s.name;
        var subpage = s.objects[selected].text;

        foreach (var k; keys(me.device.windows.window))
            if (find(id, k) == 0) {
                me.device.windows.del(id);
                break;
            }
        call(me.device.display.MFD[group][subpage], [], me);
    },

    MapMenu : func (a = 0) {
        if (a == 1)
            return;
        var menu_label = 'MAP MENU';
        if (!contains(me.device.windows.window, menu_label ~ '-bg')) {
            var level_min = 13;
            var level_max = 7;
            var levels = [ sprintf('  % 2u >', level_max) ];
            for (var i = level_max + 1; i <= level_min; i += 1)
                append(levels, sprintf(i < level_min ? '< % 2u >' : '< % 2u  ', i));
            var orientation = [ '  NORTH UP >', '<  TRK UP  >' ];
            if (getprop('/instrumentation/gps/route-distance-nm') != nil)
                append(orientation, '<  DTK UP  >');
            append(orientation, '<  HDG UP   ');
            me.device.windows.draw(
                    menu_label,
                    {x: 720, y: 100, w: 300, l:3, sep: 1},
                    [
                        {text: menu_label, type: 'title'},
                        {type: 'separator'},
                        {text: 'ZOOM LEVEL', type: 'normal'},
                        {text: sprintf('%s % 2u %s',
                                me.device.data.zoom > level_max ? '<' : ' ',
                                me.device.data.zoom,
                                me.device.data.zoom < level_min ? '>' : ' '),
                         type: 'selected|end-of-line',
                         choices: levels,
                         callback: func (id, selected) {
                             var z = me.device.windows.state[id].objects[selected].text;
                             foreach (var c; [' ', '<', '>'])
                                 z = string.replace(z, c, '');
                             me.device.data.zoom = z;
                             me.device.map.changeZoom();
                             me.device.map.update();
                         }
                        },
                        {text: 'ORIENTATION', type: 'normal'},
                        {text: (func foreach (var o; orientation) if (find(me.device.data.orientation.text, o) > -1) return o;)(),
                         type: 'editable|end-of-line',
                         choices: orientation,
                         callback: func (id, selected) {
                             var o = me.device.windows.state[id].objects[selected].text;
                             o = substr(o, 2);
                             o = substr(o, 0, size(o) - 2);
                             o = string.trim(o);
                             me.device.data.orientation.text = o;
                             me.device.map.update();
                         }
                        },
                    ]
                );
            me.device.knobs.FmsOuter = me.device.knobs.NavigateMenu;
            me.device.knobs.FmsInner = me.device.knobs.MenuSettings;
            me.device.buttons.CLR = me.device.buttons.MapMenu;
            me.device.buttons.ENT = me.device.buttons.ValidateTMRREF;
        }
        else {
            me.device.buttons.ENT = func;
            me.device.buttons.CLR = func;
            me.device.knobs.FmsInner = func;
            me.device.knobs.FmsOuter = me.device.knobs.MFD_select_page_group;
            me.device.windows.del(menu_label);
        }
    },

    DirectTo : void,
    MENU : void,
    FPL : void,
    PROC : void,
    CLR : void,
    ENT : void,
    FMS : void,
};
