/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAngular {
    static IProject project;
    static IFolder appFolder;

    @BeforeAll
    public static void setUp() throws Exception {
        AllCleanRule.closeIntro();
        AllCleanRule.enableLogging();
        project = Utils.provisionTestProject("angular-app");
        ProcessBuilder builder = NodeJSManager.prepareNPMProcessBuilder((String[])new String[]{"install", "--no-bin-links", "--ignore-scripts"}).directory(project.getLocation().toFile());
        Process process = builder.start();
        System.out.println(builder.command().toString());
        String result = process.errorReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Error Stream: >>>\n" + result + "\n<<<");
        result = process.inputReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Output Stream: >>>\n" + result + "\n<<<");
        Assertions.assertEquals((int)0, (int)process.waitFor(), (String)"npm install didn't complete property");
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)project.exists());
        appFolder = project.getFolder("src").getFolder("app");
        Assertions.assertTrue((boolean)appFolder.exists());
    }

    @BeforeEach
    public void setUpTestCase() {
        AllCleanRule.enableLogging();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        new AllCleanRule().afterEach(null);
    }

    @Test
    void testAngularTs() throws Exception {
        IFile appComponentFile = appFolder.getFile("app.component.ts");
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentFile);
        DisplayHelper.sleep((long)4000L);
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> {
            try {
                return Arrays.stream(appComponentFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)).anyMatch(marker -> marker.getAttribute("lineNumber", -1) == 5 && marker.getAttribute("message", "").contains("not exist"));
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }), (String)"Diagnostic not published in standalone component file");
        editor.close(false);
    }

    @Test
    void testAngularHtml() throws Exception {
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appFolder.getFile("app.componentWithHtml.ts"));
        DisplayHelper.sleep((long)4000L);
        IFile appComponentHTML = appFolder.getFile("app.componentWithHtml.html");
        editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentHTML);
        DisplayHelper.sleep((long)2000L);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.set(document.get() + "\n");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> {
            try {
                IMarker[] markers = appComponentHTML.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
                return Arrays.stream(markers).anyMatch(marker -> marker.getAttribute("message", "").contains("not exist"));
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }), (String)"No error found on erroneous HTML component file");
        LSContentAssistProcessor contentAssistProcessor = new LSContentAssistProcessor();
        ICompletionProposal[] proposals = contentAssistProcessor.computeCompletionProposals((ITextViewer)Utils.getViewer((AbstractTextEditor)editor), document.get().indexOf("}}"));
        proposals[0].apply(document);
        Assertions.assertEquals((Object)"<h1>{{title}}</h1>\n", (Object)document.get(), (String)"Incorrect completion insertion");
    }
}

