/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerExtension;
import org.eclipse.jface.util.IPropertyChangeListener;

public class BreakpointOrganizerManager {
    private static BreakpointOrganizerManager fgManager;
    private Map<String, IBreakpointOrganizer> fOrganizers = new HashMap<String, IBreakpointOrganizer>();
    private List<IBreakpointOrganizer> fSorted = null;

    public static BreakpointOrganizerManager getDefault() {
        if (fgManager == null) {
            fgManager = new BreakpointOrganizerManager();
        }
        return fgManager;
    }

    private BreakpointOrganizerManager() {
        this.loadOrganizers();
        this.start("org.eclipse.debug.ui.workingSetOrganizer");
        this.start("org.eclipse.debug.ui.breakpointWorkingSetOrganizer");
    }

    private void start(String organizerId) {
        IBreakpointOrganizer organizer = this.getOrganizer(organizerId);
        IPropertyChangeListener listener = event -> {};
        organizer.addPropertyChangeListener(listener);
        organizer.removePropertyChangeListener(listener);
    }

    private void loadOrganizers() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "breakpointOrganizers");
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            BreakpointOrganizerExtension organizer = new BreakpointOrganizerExtension(element);
            if (BreakpointOrganizerManager.validateOrganizer(organizer)) {
                this.fOrganizers.put(organizer.getIdentifier(), organizer);
            }
            ++n2;
        }
    }

    protected static boolean validateOrganizer(IBreakpointOrganizer organizer) {
        String id = organizer.getIdentifier();
        String label = organizer.getLabel();
        return id != null && id.length() > 0 && label != null && label.length() > 0;
    }

    public IBreakpointOrganizer[] getOrganizers() {
        if (this.fSorted == null) {
            Collection<IBreakpointOrganizer> collection = this.fOrganizers.values();
            this.fSorted = new ArrayList<IBreakpointOrganizer>();
            this.fSorted.addAll(collection);
            Collections.sort(this.fSorted, Comparator.comparing(IBreakpointOrganizer::getLabel));
        }
        return this.fSorted.toArray(new IBreakpointOrganizer[this.fSorted.size()]);
    }

    public IBreakpointOrganizer getOrganizer(String id) {
        return this.fOrganizers.get(id);
    }

    public void shutdown() {
        IBreakpointOrganizer[] iBreakpointOrganizerArray = this.getOrganizers();
        int n = iBreakpointOrganizerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpointOrganizer organizer = iBreakpointOrganizerArray[n2];
            organizer.dispose();
            ++n2;
        }
    }
}

