/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

public class DSPBreakpointManager
implements IBreakpointManagerListener,
IBreakpointListener {
    private final Map<Source, List<SourceBreakpoint>> targetBreakpoints = new HashMap<Source, List<SourceBreakpoint>>();
    private final IDebugProtocolServer debugProtocolServer;
    private final IBreakpointManager platformBreakpointManager;
    private final Capabilities capabilities;

    public DSPBreakpointManager(IBreakpointManager platformBreakpointManager, IDebugProtocolServer debugProtocolServer, Capabilities capabilities) {
        this.debugProtocolServer = debugProtocolServer;
        this.platformBreakpointManager = platformBreakpointManager;
        this.capabilities = capabilities;
    }

    public CompletableFuture<Void> initialize() {
        this.platformBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.platformBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        return this.resendAllTargetBreakpoints(this.platformBreakpointManager.isEnabled());
    }

    public void shutdown() {
        this.platformBreakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this.platformBreakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof ILineBreakpoint;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.resendAllTargetBreakpoints(enabled);
    }

    private CompletableFuture<Void> resendAllTargetBreakpoints(boolean enabled) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = this.platformBreakpointManager.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.supportsBreakpoint(breakpoint)) {
                if (enabled) {
                    this.addBreakpointToMap(breakpoint);
                } else {
                    this.deleteBreakpointFromMap(breakpoint);
                }
            }
            ++n2;
        }
        return this.sendBreakpoints();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && this.platformBreakpointManager.isEnabled() || !breakpoint.isRegistered()) {
                    this.addBreakpointToMap(breakpoint);
                    this.sendBreakpoints();
                }
            }
            catch (CoreException e) {
                DSPPlugin.logError(e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            this.deleteBreakpointFromMap(breakpoint);
            this.sendBreakpoints();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && this.platformBreakpointManager.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void addBreakpointToMap(IBreakpoint breakpoint) {
        Assert.isTrue((this.supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint ? 1 : 0) != 0);
        if (breakpoint instanceof ILineBreakpoint) {
            int lineNumber;
            ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
            IMarker marker = lineBreakpoint.getMarker();
            IResource resource = marker.getResource();
            IPath location = resource.getLocation();
            String path = location.toOSString();
            String name = location.lastSegment();
            try {
                lineNumber = lineBreakpoint.getLineNumber();
            }
            catch (CoreException e) {
                lineNumber = -1;
            }
            Source source = new Source();
            source.setName(name);
            source.setPath(path);
            List sourceBreakpoints = this.targetBreakpoints.computeIfAbsent(source, s -> new ArrayList());
            SourceBreakpoint sourceBreakpoint = new SourceBreakpoint();
            sourceBreakpoint.setLine(lineNumber);
            sourceBreakpoints.add(sourceBreakpoint);
        }
    }

    private void deleteBreakpointFromMap(IBreakpoint breakpoint) {
        Assert.isTrue((this.supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint ? 1 : 0) != 0);
        if (breakpoint instanceof ILineBreakpoint) {
            int lineNumber;
            ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
            IResource resource = lineBreakpoint.getMarker().getResource();
            IPath location = resource.getLocation();
            String path = location.toOSString();
            String name = location.lastSegment();
            try {
                lineNumber = lineBreakpoint.getLineNumber();
            }
            catch (CoreException e) {
                lineNumber = -1;
            }
            for (Map.Entry<Source, List<SourceBreakpoint>> entry : this.targetBreakpoints.entrySet()) {
                Source source = entry.getKey();
                if (!Objects.equals(name, source.getName()) || !Objects.equals(path, source.getPath())) continue;
                List<SourceBreakpoint> bps = entry.getValue();
                Iterator<SourceBreakpoint> iterator = bps.iterator();
                while (iterator.hasNext()) {
                    SourceBreakpoint sourceBreakpoint = iterator.next();
                    if (!Objects.equals(lineNumber, sourceBreakpoint.getLine())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private CompletableFuture<Void> sendBreakpoints() {
        ArrayList<CompletionStage> all = new ArrayList<CompletionStage>();
        Iterator<Map.Entry<Source, List<SourceBreakpoint>>> iterator = this.targetBreakpoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Source, List<SourceBreakpoint>> entry = iterator.next();
            Source source = entry.getKey();
            List<SourceBreakpoint> bps = entry.getValue();
            int[] lines = bps.stream().mapToInt(SourceBreakpoint::getLine).toArray();
            SourceBreakpoint[] sourceBps = bps.toArray(new SourceBreakpoint[bps.size()]);
            SetBreakpointsArguments arguments = new SetBreakpointsArguments();
            arguments.setSource(source);
            arguments.setLines(lines);
            arguments.setBreakpoints(sourceBps);
            arguments.setSourceModified(Boolean.valueOf(false));
            CompletableFuture future = this.debugProtocolServer.setBreakpoints(arguments);
            CompletionStage future2 = future.thenAccept(bpResponse -> {});
            all.add(future2);
            if (!bps.isEmpty()) continue;
            iterator.remove();
        }
        return CompletableFuture.allOf(all.toArray(new CompletableFuture[all.size()]));
    }

    public void breakpointEvent(BreakpointEventArguments args) {
    }
}

