/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;

class ModelTokensChangedEventBuilder {
    private final ITMModel model;
    private final List<Range> ranges;

    public ModelTokensChangedEventBuilder(ITMModel model) {
        this.model = model;
        this.ranges = new ArrayList<Range>();
    }

    public void registerChangedTokens(int lineNumber) {
        Range previousRange;
        Range range = previousRange = this.ranges.isEmpty() ? null : this.ranges.get(this.ranges.size() - 1);
        if (previousRange != null && previousRange.toLineNumber == lineNumber - 1) {
            ++previousRange.toLineNumber;
        } else {
            this.ranges.add(new Range(lineNumber));
        }
    }

    public ModelTokensChangedEvent build() {
        if (this.ranges.isEmpty()) {
            return null;
        }
        return new ModelTokensChangedEvent(this.ranges, this.model);
    }
}

