/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { YamlCommands } from '../../commands';
import { URI } from 'vscode-uri';
export function registerCommands(commandExecutor, connection) {
    commandExecutor.registerCommand(YamlCommands.JUMP_TO_SCHEMA, (uri) => __awaiter(this, void 0, void 0, function* () {
        if (!uri) {
            return;
        }
        if (!uri.startsWith('file')) {
            const origUri = URI.parse(uri);
            const customUri = URI.from({
                scheme: 'json-schema',
                authority: origUri.authority,
                path: origUri.path.endsWith('.json') ? origUri.path : origUri.path + '.json',
                fragment: uri,
            });
            uri = customUri.toString();
        }
        const result = yield connection.window.showDocument({ uri: uri, external: false, takeFocus: true });
        if (!result) {
            connection.window.showErrorMessage(`Cannot open ${uri}`);
        }
    }));
}
//# sourceMappingURL=yamlCommands.js.map