import { StringBuffer, PieceTreeBase } from './pieceTreeBase';
export declare const UTF8_BOM_CHARACTER: string;
export declare function startsWithUTF8BOM(str: string): boolean;
export declare const enum DefaultEndOfLine {
    /**
     * Use line feed (\n) as the end of line character.
     */
    LF = 1,
    /**
     * Use carriage return and line feed (\r\n) as the end of line character.
     */
    CRLF = 2
}
export declare class PieceTreeTextBufferFactory {
    private readonly _chunks;
    private readonly _bom;
    private readonly _cr;
    private readonly _lf;
    private readonly _crlf;
    private readonly _normalizeEOL;
    constructor(_chunks: StringBuffer[], _bom: string, _cr: number, _lf: number, _crlf: number, _normalizeEOL: boolean);
    private _getEOL;
    create(defaultEOL: DefaultEndOfLine): PieceTreeBase;
    getFirstLineText(lengthLimit: number): string;
}
export declare class PieceTreeTextBufferBuilder {
    private readonly chunks;
    private BOM;
    private _hasPreviousChar;
    private _previousChar;
    private readonly _tmpLineStarts;
    private cr;
    private lf;
    private crlf;
    constructor();
    acceptChunk(chunk: string): void;
    private _acceptChunk1;
    private _acceptChunk2;
    finish(normalizeEOL?: boolean): PieceTreeTextBufferFactory;
    private _finish;
}
