/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

public abstract class Rule {
    public final int id;
    private boolean nameIsCapturing;
    private String name;
    private boolean contentNameIsCapturing;
    private String contentName;

    public Rule(int id, String name, String contentName) {
        this.id = id;
        this.name = name;
        this.nameIsCapturing = RegexSource.hasCaptures(this.name);
        this.contentName = contentName;
        this.contentNameIsCapturing = RegexSource.hasCaptures(this.contentName);
    }

    public String getName(String lineText, IOnigCaptureIndex[] captureIndices) {
        if (!this.nameIsCapturing) {
            return this.name;
        }
        return RegexSource.replaceCaptures(this.name, lineText, captureIndices);
    }

    public String getContentName(String lineText, IOnigCaptureIndex[] captureIndices) {
        if (!this.contentNameIsCapturing) {
            return this.contentName;
        }
        return RegexSource.replaceCaptures(this.contentName, lineText, captureIndices);
    }

    public abstract void collectPatternsRecursive(IRuleRegistry var1, RegExpSourceList var2, boolean var3);

    public abstract ICompiledRule compile(IRuleRegistry var1, String var2, boolean var3, boolean var4);
}

