/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AbstractJoinColumn;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Insertable;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.Updatable;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.AbstractJoinColumnDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class JoinColumnDialog
extends AbstractJoinColumnDialog {
    private Insertable insertable;
    private ComboViewer insertableComboViewer;
    private Updatable updatable;
    private ComboViewer updatableComboViewer;
    private SingleRelationshipMapping singleRelationshipMapping;

    JoinColumnDialog(Shell parent, SingleRelationshipMapping singleRelationshipMapping) {
        super(parent);
        this.singleRelationshipMapping = singleRelationshipMapping;
    }

    JoinColumnDialog(Shell parent, JoinColumn joinColumn) {
        super(parent, (AbstractJoinColumn)joinColumn);
        this.singleRelationshipMapping = (SingleRelationshipMapping)joinColumn.getParent();
    }

    protected Control createDialogArea(Composite parent) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label insertableLabel = new Label(composite, 16384);
        insertableLabel.setText(DaliUiMessages.JoinColumnDialog_insertable);
        insertableLabel.setLayoutData((Object)new GridData());
        this.insertableComboViewer = this.buildInsertableComboViewer(composite);
        this.insertableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.insertableComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_columnInsertable");
        Label updatableLabel = new Label(composite, 16384);
        updatableLabel.setText(DaliUiMessages.JoinColumnDialog_updatable);
        updatableLabel.setLayoutData((Object)new GridData());
        this.updatableComboViewer = this.buildUpdatableComboViewer(composite);
        this.updatableComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.updatableComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_columnUpdatable");
        return composite;
    }

    private ComboViewer buildInsertableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Insertable.VALUES.toArray());
        Insertable sel = this.joinColumn() == null ? Insertable.DEFAULT_LITERAL : this.joinColumn().getInsertable();
        viewer.setSelection((ISelection)new StructuredSelection((Object)sel));
        return viewer;
    }

    private ComboViewer buildUpdatableComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Updatable.VALUES.toArray());
        Updatable sel = this.joinColumn() == null ? Updatable.DEFAULT_LITERAL : this.joinColumn().getUpdatable();
        viewer.setSelection((ISelection)new StructuredSelection((Object)sel));
        return viewer;
    }

    protected Table getNameTable() {
        return this.singleRelationshipMapping.getTypeMapping().getResolvedDBTable();
    }

    protected Table getReferencedNameTable() {
        Entity targetEntity = this.singleRelationshipMapping.getResolvedTargetEntity();
        if (targetEntity != null) {
            return targetEntity.getResolvedDBTable();
        }
        return null;
    }

    private JoinColumn joinColumn() {
        return (JoinColumn)this.getJoinColumn();
    }

    public Insertable getInsertable() {
        return this.insertable;
    }

    public Updatable getUpdatable() {
        return this.updatable;
    }

    public boolean close() {
        ISelection selection = this.insertableComboViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.insertable = (Insertable)((IStructuredSelection)selection).getFirstElement();
        }
        if ((selection = this.updatableComboViewer.getSelection()) instanceof IStructuredSelection) {
            this.updatable = (Updatable)((IStructuredSelection)selection).getFirstElement();
        }
        return super.close();
    }
}

