/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.pattern;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.pattern.IResourceKey;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;

public abstract class BaseResourceKey
implements IResourceKey {
    private final Class<?> m_anchorClass;
    private final String m_resourceName;
    private final Permutation m_permutationCtx;

    public BaseResourceKey(Class<?> anchorClass, String resourceName, Permutation permutationCtx) {
        this.assertNotNull(resourceName, "Resource name must not be null");
        this.m_anchorClass = anchorClass;
        this.m_resourceName = resourceName;
        this.m_permutationCtx = permutationCtx;
    }

    public Class<?> getAnchorClass() {
        return this.m_anchorClass;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public Permutation getPermutation() {
        return this.m_permutationCtx;
    }

    public String toString() {
        Z z = new Z();
        z.format("Anchor class", this.m_anchorClass);
        z.format("Resource name", (Object)this.m_resourceName);
        z.format("Permutation key", (Object)this.m_permutationCtx);
        return z.toString();
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new DsfRuntimeException(msg);
        }
    }
}

