/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.slot;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;

public class JsResourceSlotAssignment {
    private final Map<String, String> m_refToSlotMapping;
    private final Map<String, String> m_urnPrefixToSlotMapping;

    public JsResourceSlotAssignment() {
        this.m_refToSlotMapping = new HashMap<String, String>();
        this.m_urnPrefixToSlotMapping = new HashMap<String, String>();
    }

    public JsResourceSlotAssignment(Map<String, String> refToSlotMapping, Map<String, String> urnPrefixToSlotMapping) {
        this.m_refToSlotMapping = new LinkedHashMap<String, String>(refToSlotMapping != null ? refToSlotMapping : Collections.EMPTY_MAP);
        this.m_urnPrefixToSlotMapping = new LinkedHashMap<String, String>(urnPrefixToSlotMapping != null ? urnPrefixToSlotMapping : Collections.EMPTY_MAP);
    }

    public Map<String, String> getUrnsMap() {
        return Collections.unmodifiableMap(this.m_refToSlotMapping);
    }

    public Map<String, String> getUrnPrefixesMap() {
        return Collections.unmodifiableMap(this.m_urnPrefixToSlotMapping);
    }

    public void put(IJsResourceRef resource, String slotName) {
        this.assertNotNull(resource, "JS resource ref must not be null");
        this.assertNotNull(slotName, "Slot name must not be null");
        this.m_refToSlotMapping.put(resource.getUrn(), slotName);
    }

    public void put(JsResource resource, String slotName) {
        this.assertNotNull(resource, "JS resource must not be null");
        this.assertNotNull(slotName, "Slot name must not be null");
        this.m_refToSlotMapping.put(resource.getUrn(), slotName);
    }

    public void put(String urnPrefix, String slotName) {
        this.assertNotNull(urnPrefix, "Urn Prefix must not be null");
        this.assertNotNull(slotName, "Slot name must not be null");
        this.m_urnPrefixToSlotMapping.put(urnPrefix, slotName);
    }

    public String getSlotName(IJsResourceRef resource) {
        return this.getSlotName(resource.getUrn());
    }

    public String getSlotName(JsResource resource) {
        return this.getSlotName(resource.getUrn());
    }

    public String getSlotName(String urn) {
        String slotName = this.m_refToSlotMapping.get(urn);
        if (slotName == null) {
            slotName = this.getSlotNameFromUrnPrefix(urn);
        }
        return slotName;
    }

    public boolean hasAssignment(IJsResourceRef ref) {
        return this.m_refToSlotMapping.containsKey(ref.getUrn());
    }

    public boolean hasAssignment(JsResource resource) {
        return this.m_refToSlotMapping.containsKey(resource.getUrn());
    }

    private String getSlotNameFromUrnPrefix(String urn) {
        Set<String> keys = this.m_urnPrefixToSlotMapping.keySet();
        for (String key : keys) {
            if (!urn.startsWith(key)) continue;
            return this.m_urnPrefixToSlotMapping.get(key);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.m_refToSlotMapping.entrySet()) {
            sb.append("  JsRef URN: ").append(entry.getKey()).append("-->").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public Iterator<String> getUrns() {
        return this.m_refToSlotMapping.keySet().iterator();
    }

    public Iterator<String> getUrnPrefixes() {
        return this.m_urnPrefixToSlotMapping.keySet().iterator();
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new DsfRuntimeException(msg);
        }
    }
}

