/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.embedded.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.ProxyRule;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.ProxyServerConfig;

public class ProxyServer
extends Server {
    private ProxyServerConfig m_config = null;
    private int m_port = 0;

    public ProxyServer(int port) {
        super(port);
        this.m_port = port;
        this.m_config = ProxyServerConfig.getInstance();
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        int port;
        String localHost;
        if (target.equals("443")) {
            return;
        }
        String urlString = request.getRequestURL().toString();
        String uri = request.getRequestURI();
        String serverName = request.getServerName().toUpperCase();
        if ((serverName.indexOf(localHost = InetAddress.getLocalHost().getHostName().toUpperCase()) != -1 || serverName.compareToIgnoreCase("localhost") == 0) && this.m_port == (port = request.getServerPort())) {
            request.setAttribute("viewPath", (Object)this.m_config.getViewPath());
            request.setAttribute("viewRoot", (Object)this.m_config.getViewRoot());
            super.handle(target, null, request, response);
            return;
        }
        for (ProxyRule rule : this.m_config.getRules()) {
            switch (rule.match(uri)) {
                case 2: {
                    break;
                }
                case 0: {
                    request.setAttribute("resource", (Object)rule.getResourceURI());
                    request.setAttribute("viewPath", (Object)this.m_config.getViewPath());
                    request.setAttribute("viewRoot", (Object)this.m_config.getViewRoot());
                    super.handle(target, null, request, response);
                    return;
                }
                case 1: {
                    System.out.println("forward request to server : " + urlString);
                    this.forwardRequest(request, response);
                    return;
                }
            }
        }
        this.forwardRequest(request, response);
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String port = "";
        String host = "";
        int c = uri.indexOf(58);
        if (c >= 0) {
            port = uri.substring(c + 1);
            host = uri.substring(0, c);
            if (host.indexOf(47) > 0) {
                host = host.substring(host.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(inetAddress.getAddress(), inetAddress.getPort());
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        IO.copyThread((InputStream)socket.getInputStream(), (OutputStream)out);
        IO.copy((InputStream)in, (OutputStream)socket.getOutputStream());
    }

    private void forwardRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpClient client = new HttpClient();
        String url = req.getRequestURL().toString();
        GetMethod method = new GetMethod(url);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        try {
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusLine());
                }
                InputStream in = method.getResponseBodyAsStream();
                Header[] hs = method.getResponseHeaders();
                int i = 0;
                while (i < hs.length) {
                    res.addHeader(hs[i].getName(), hs[i].getValue());
                    ++i;
                }
                res.addHeader("Via", "1.1 (jetty)");
                res.setStatus(statusCode);
                IO.copy((InputStream)in, (OutputStream)res.getOutputStream());
            }
            catch (HttpException e) {
                System.err.println("Fatal protocol violation: " + e.getMessage());
                e.printStackTrace();
                method.releaseConnection();
            }
            catch (IOException e) {
                System.err.println("Fatal transport error: " + e.getMessage());
                e.printStackTrace();
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public ProxyServerConfig getConfig() {
        return this.m_config;
    }
}

