/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet;

import java.util.Map;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.html.dom.util.IDeferConstruction;
import org.eclipse.vjet.vsf.dervlet.BrowserManager;
import org.eclipse.vjet.vsf.dervlet.CoreDervlet;
import org.eclipse.vjet.vsf.dervlet.DsfDervlet;
import org.eclipse.vjet.vsf.dervlet.defaultdervs.JsDervlet;
import org.eclipse.vjet.vsf.dervlet.defaultdervs.SimpleAdminServlet;
import org.eclipse.vjet.vsf.dervlet.defaultdervs.VjDervlet;
import org.eclipse.vjet.vsf.dervlet.embedded.proxy.EmbeddedProxyServer;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServer;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServerConfig;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRef;

public class DsfDervletUtil {
    static final String ESF_SERVLET_NAME = "esf";
    private static EmbeddedServer m_server;
    private static DsfDervletUtil s_instance;

    static {
        s_instance = new DsfDervletUtil();
    }

    private DsfDervletUtil() {
    }

    public static DsfDervletUtil getInstance() {
        return s_instance;
    }

    protected EmbeddedServer getServer() {
        if (m_server == null) {
            m_server = this.createServer();
            this.init(m_server);
        }
        return m_server;
    }

    protected EmbeddedServer createServer() {
        int port = (int)(Math.random() * 101.0);
        port = Math.abs(port) + 10000;
        EmbeddedServer server = EmbeddedServer.create(port, null, null);
        server.start();
        return server;
    }

    protected void createAndStartServerWithUniquePort() {
        if (m_server == null) {
            m_server = EmbeddedServer.create(EmbeddedServer.getUniquePort());
            m_server.start();
        }
    }

    protected DsfDervlet runAsDervlet(DsfDervlet dervlet) {
        this.getServer().addDervlet(dervlet);
        String url = String.valueOf(this.getServer().getBaseUrl()) + dervlet.getPath();
        BrowserManager.displayUrlInDefault(url);
        return dervlet;
    }

    protected DsfDervlet runAsDervlet2(DsfDervlet dervlet) {
        this.createAndStartServerWithUniquePort();
        return this.runAsDervlet(dervlet);
    }

    public DsfDervlet asDervlet(final DNode node, String dervletName) {
        String dname = dervletName == null ? node.getNodeName() : dervletName;
        return new DsfDervlet(dname){
            final long serialVersionUID = 1L;
            {
                super($anonymous0);
                this.serialVersionUID = 1L;
            }

            @Override
            protected DNode createFragment() {
                if (node instanceof IDeferConstruction) {
                    ((IDeferConstruction)node).finish();
                }
                return node;
            }
        };
    }

    protected DsfDervlet runAsDervletAdmin(DNode node, String dervletName) {
        DsfDervlet dervlet = this.asDervlet(node, dervletName);
        this.getServer().addDervlet(dervlet);
        BrowserManager.displayUrlInDefault(this.getServer().getAdminUrl());
        return dervlet;
    }

    protected DsfDervlet runAsDervlet(DNode node, String dervletName) {
        DsfDervlet dervlet = this.asDervlet(node, dervletName);
        this.getServer().addDervlet(dervlet);
        String url = String.valueOf(this.getServer().getBaseUrl()) + dervlet.getPath();
        BrowserManager.displayUrlInDefault(url);
        return dervlet;
    }

    protected DsfDervlet runAsDervlet(DNode node, String dervletName, DISPLAY_TYPE displayType) {
        DsfDervlet dervlet = this.asDervlet(node, dervletName);
        this.getServer().addDervlet(dervlet);
        String url = String.valueOf(this.getServer().getBaseUrl()) + dervlet.getPath();
        if (displayType == DISPLAY_TYPE.FF) {
            BrowserManager.displayUrlInFirefox(url);
        } else if (displayType == DISPLAY_TYPE.IE) {
            BrowserManager.displayUrlInIE(url);
        } else {
            BrowserManager.displayUrlInDefault(url);
        }
        return dervlet;
    }

    protected DsfDervlet runAsDervlet(String docLevelHtml, String dervletName) {
        DRawString rawString = new DRawString(docLevelHtml);
        return this.runAsDervlet((DNode)rawString, dervletName);
    }

    protected void addDervlet(DsfDervlet dervlet, String name) {
        this.getServer().addDervlet((CoreDervlet)dervlet, name);
    }

    protected void addDervlet(DsfDervlet dervlet) {
        this.getServer().addDervlet((CoreDervlet)dervlet, dervlet.getServletName());
    }

    protected void addJs(JsResourceRef jsRef) {
        this.addJs(this.getServer(), jsRef);
    }

    protected void addJs(EmbeddedServer server, JsResourceRef jsRef) {
        JsResource resource = jsRef.getResource();
        if (!(resource.getHandleProvider() instanceof JsDervlet.JsResourceHandleProvider)) {
            resource.setHandleProvider((JsResource.IHandleProvider)new JsDervlet.JsResourceHandleProvider(server, resource));
        }
    }

    protected String getBaseUrl() {
        return this.getServer().getBaseUrl();
    }

    public String toUrlParameterPart(Map map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            String name = this.toString(entry.getKey());
            String value = this.toString(entry.getValue());
            if (name == null || name.trim().length() <= 0) continue;
            if (first) {
                sb.append('?');
                first = false;
            } else {
                sb.append('&');
            }
            sb.append(name).append('=');
            if (value == null) {
                sb.append("");
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    protected String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    protected EmbeddedServer create() {
        return this.create(EmbeddedServer.getUniquePort());
    }

    protected EmbeddedServer create(int port) {
        return this.create(port, null, null);
    }

    protected EmbeddedServer create(int port, boolean isProxy) {
        EmbeddedServerConfig config = new EmbeddedServerConfig(port, null, null);
        if (isProxy) {
            return EmbeddedProxyServer.createProxyServer(config);
        }
        return this.create(port, null, null);
    }

    protected EmbeddedServer create(String contextPath, String resourceBase) {
        return this.create(EmbeddedServer.getUniquePort(), contextPath, resourceBase);
    }

    protected EmbeddedServer create(int port, String contextPath, String resourceBase) {
        EmbeddedServerConfig config = new EmbeddedServerConfig(port, contextPath, resourceBase);
        return this.create(config);
    }

    protected EmbeddedServer create(EmbeddedServerConfig config) {
        if (config == null) {
            throw new RuntimeException("Config must not be null");
        }
        EmbeddedServer server = EmbeddedServer.getServer(config.getPort());
        if (server != null) {
            return server;
        }
        server = EmbeddedServer.create(config);
        this.init(server);
        return server;
    }

    protected void init(EmbeddedServer server) {
        server.addAdminServletWithMapping(SimpleAdminServlet.class, "/*");
        server.addServlet(VjDervlet.class, "vjRunner", "/vjRunner/*");
    }

    public static enum DISPLAY_TYPE {
        FF,
        IE;

    }
}

