/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.Iterator;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.vsf.dapunit.DapUnitConfig;
import org.eclipse.vjet.vsf.dapunit.MsgError;
import org.eclipse.vjet.vsf.dapunit.UserAgentsEnum;

public class MockDlcDispatcher
implements IDLCDispatcher {
    private static final String NAVIGATOR_USER_AGENT = "navigator.userAgent";
    private DapCaptureData.ViewCapture m_curViewCapture;
    private DapCaptureData.IEventCapture m_curEventCapture;
    private Iterator<DapCaptureData.IActionInfo> m_actionItr;
    private final UserAgentsEnum m_userAgent;
    private DapUnitConfig m_config;

    MockDlcDispatcher(DapUnitConfig config) {
        this(config, null);
    }

    MockDlcDispatcher(DapUnitConfig config, UserAgentsEnum userAgent) {
        this.m_config = config;
        this.m_userAgent = userAgent;
    }

    DapUnitConfig getConfig() {
        return this.m_config;
    }

    public void send(String data) {
        DapCaptureData.DlcSend dlcSend = this.getCurSend();
        String expected = dlcSend != null ? dlcSend.getMessage() : null;
        MsgError msgError = this.m_config.getDefaultMsgValidator().validate(expected, data);
        if (msgError != null) {
            this.m_config.getErrorReporter().addMsgError(msgError, expected, data, this.m_curEventCapture, this.m_curViewCapture);
        }
    }

    public String request(String message, int timeoutInMilli) {
        if (NAVIGATOR_USER_AGENT.equals(message) && this.m_userAgent != null) {
            this.moveToNext();
            return this.m_userAgent.getName();
        }
        DapCaptureData.DlcRnR rnr = this.getCurRnR();
        String expected = rnr != null ? rnr.getRequest() : null;
        MsgError msgError = this.m_config.getDefaultMsgValidator().validate(expected, message);
        if (msgError != null) {
            this.m_config.getErrorReporter().addMsgError(msgError, expected, message, this.m_curEventCapture, this.m_curViewCapture);
        }
        if (rnr != null) {
            return rnr.getResponse();
        }
        return null;
    }

    MockDlcDispatcher startView(DapCaptureData.ViewCapture expectedViewCapture) {
        if (expectedViewCapture == null) {
            throw new DsfRuntimeException("expectedViewCapture is null");
        }
        this.m_curViewCapture = expectedViewCapture;
        return this;
    }

    MockDlcDispatcher startInit(DapCaptureData.EventCapture expectedInitCapture) {
        this.startEvent((DapCaptureData.IEventCapture)expectedInitCapture);
        return this;
    }

    MockDlcDispatcher endInit() {
        this.endEvent();
        return this;
    }

    void startEvent(DapCaptureData.IEventCapture eventCapture) {
        this.m_curEventCapture = eventCapture;
        this.m_actionItr = this.m_curEventCapture.getActionsIter();
    }

    void endEvent() {
        DapCaptureData.IDlcMsg dlcMsg = this.getNextDLCMsg();
        if (dlcMsg != null) {
            this.m_config.getErrorReporter().addMsgError(new MsgError("Missing DLC msg"), dlcMsg.toString(), null, this.m_curEventCapture, this.m_curViewCapture);
        }
    }

    /*
     * Unable to fully structure code
     */
    private DapCaptureData.DlcSend getCurSend() {
        if (this.m_actionItr != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            actionInfo = this.m_actionItr.next();
            if (!(actionInfo instanceof DapCaptureData.DlcSend)) continue;
            return (DapCaptureData.DlcSend)actionInfo;
lbl6:
            // 2 sources

            ** while (this.m_actionItr.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private DapCaptureData.DlcRnR getCurRnR() {
        if (this.m_actionItr != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            actionInfo = this.m_actionItr.next();
            if (!(actionInfo instanceof DapCaptureData.DlcRnR)) continue;
            return (DapCaptureData.DlcRnR)actionInfo;
lbl6:
            // 2 sources

            ** while (this.m_actionItr.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    private void moveToNext() {
        if (this.m_actionItr != null && this.m_actionItr.hasNext()) {
            this.m_actionItr.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    private DapCaptureData.IDlcMsg getNextDLCMsg() {
        if (this.m_actionItr != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            actionInfo = this.m_actionItr.next();
            if (!(actionInfo instanceof DapCaptureData.IDlcMsg)) continue;
            return (DapCaptureData.IDlcMsg)actionInfo;
lbl6:
            // 2 sources

            ** while (this.m_actionItr.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }
}

