/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.js;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.resource.pattern.IResourceRef;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.slot.IJsResourceReplacement;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlot;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.resource.slot.simple.SimpleJsResourceSlotter;
import org.eclipse.vjet.dsf.spec.collector.ResourceSpecCollector;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.export.IExportJsResource;
import org.eclipse.vjet.dsf.spec.export.IExportJsSlotter;
import org.eclipse.vjet.dsf.spec.export.JsExportableCompCollector;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpecs;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vsf.aggregator.cache.JsResourceCache;
import org.eclipse.vjet.vsf.aggregator.cache.JsSystemLibCache;
import org.eclipse.vjet.vsf.aggregator.cache.ResourceAggregationControl;
import org.eclipse.vjet.vsf.aggregator.cache.ViewSpecResourceCacheMgr;
import org.eclipse.vjet.vsf.aggregator.cache.js.JsResourceAggregator;
import org.eclipse.vjet.vsf.aggregator.js.JsResourceApplier;
import org.eclipse.vjet.vsf.aggregator.js.registry.JsCompRegistryProcessor;
import org.eclipse.vjet.vsf.docprocessing.IJsProcessor;
import org.eclipse.vjet.vsf.docprocessing.IJsResourceApplier;
import org.eclipse.vjet.vsf.jsref.ctx.ResourceCtx;
import org.eclipse.vjet.vsf.jsruntime.JsRuntimeVersion;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;

public class BaseJsProcessor
implements IJsProcessor {
    protected JsResourceSlotter m_slotter;
    protected IJsResourceApplier m_applier;
    protected JsSystemLibCache m_libCache;
    private IncompatibleJsSlotterMgr m_incompatibleSlotterMgr = new IncompatibleJsSlotterMgr();
    private boolean m_processInstanceBasedJsContribution = true;

    public BaseJsProcessor() {
        this(null, null, null);
    }

    public BaseJsProcessor(JsResourceSlotter slotter, IJsResourceApplier applier, JsSystemLibCache libCache) {
        this(slotter, applier, libCache, true);
    }

    public BaseJsProcessor(JsResourceSlotter slotter, IJsResourceApplier applier, JsSystemLibCache libCache, boolean processInstanceBasedJsContribution) {
        this.m_applier = applier != null ? applier : this.createApplier();
        this.setSlotter(slotter != null ? slotter : this.createSlotter());
        this.setLibCache(libCache);
        this.m_processInstanceBasedJsContribution = processInstanceBasedJsContribution;
    }

    public void process(DDocument doc) {
        this.process(doc, null);
    }

    public void process(DDocument doc, IViewSpec viewSpec) {
        this.aggragateJs(doc, viewSpec);
        this.applyJsToDoc(doc);
    }

    public IJsResourceApplier getApplier() {
        return this.m_applier;
    }

    public void setApplier(IJsResourceApplier applier) {
        this.m_applier = applier;
    }

    public IJsResourceApplier createApplier() {
        return new JsResourceApplier();
    }

    public JsSystemLibCache getLibCache() {
        return this.m_libCache;
    }

    public void setLibCache(JsSystemLibCache cache) {
        this.m_libCache = cache;
        if (this.m_slotter != null && this.m_libCache != null) {
            this.m_slotter.setResourceReplacement((IJsResourceReplacement)this.m_libCache);
        }
    }

    public JsResourceSlotter getSlotter() {
        return this.m_slotter;
    }

    public void setSlotter(JsResourceSlotter slotter) {
        this.m_slotter = slotter;
        if (this.m_slotter.getSlotAssignmentList() == null) {
            this.m_slotter.addSlotAssignment(this.createAssignment());
        }
        if (JsRuntimeVersion.enabled() && slotter.getRuntimeVersion() == null) {
            this.m_slotter.setRuntimeVersion(JsRuntimeVersion.getCurrentVersion());
        }
        if (this.m_slotter != null && this.m_libCache != null) {
            this.m_slotter.setResourceReplacement((IJsResourceReplacement)this.m_libCache);
        }
    }

    protected void applyJsToDoc(DDocument doc) {
        this.m_applier.apply(doc, this.m_slotter, !this.m_incompatibleSlotterMgr.isEmpty());
        this.m_incompatibleSlotterMgr.apply(doc);
    }

    protected void aggragateJs(DDocument doc, IViewSpec viewSpec) {
        ResourceCtx context = ResourceCtx.ctx();
        Permutation permutation = Permutation.getFromCtx();
        JsExportableCompCollector instanceCollector = context.getJsInstanceCollector();
        ResourceSpecCollector specCollector = new ResourceSpecCollector();
        HashSet<String> exclusionList = new HashSet<String>();
        if (viewSpec != null) {
            Set urns;
            Set<String> exclusion = BaseJsProcessor.aggregateViewSpec(viewSpec, permutation, specCollector, this.m_slotter);
            if (exclusion != null) {
                exclusionList.addAll(exclusion);
            }
            if ((!viewSpec.isJsSystemLibCache() || viewSpec.isForceJsExclusionCheck()) && (urns = viewSpec.getJsExclusionResourceUrns()) != null) {
                exclusionList.addAll(urns);
            }
        }
        this.aggregateContext(context, specCollector, exclusionList);
        this.aggregateRunTimeInstances(instanceCollector, exclusionList);
        if (this.m_processInstanceBasedJsContribution) {
            this.aggregateComponentInitialization();
        }
    }

    private void aggregateComponentInitialization() {
        JsCompRegistryProcessor.process(this.m_slotter);
    }

    private void aggregateRunTimeInstances(JsExportableCompCollector instanceCollector, Set<String> exclusion) {
        if (instanceCollector != null && instanceCollector.hasExportedResource()) {
            for (IExportJsResource resource : instanceCollector.getExportedResources()) {
                JsResourceSlotter slotter = this.m_slotter;
                if (resource instanceof IExportJsSlotter) {
                    IExportJsSlotter exportJsSlotter = (IExportJsSlotter)resource;
                    if (JsRuntimeVersion.enabled()) {
                        String currentRtVersion = this.m_slotter.getRuntimeVersion();
                        String anotherRtVersion = exportJsSlotter.getJsRuntimeVersion();
                        if (currentRtVersion != null && !currentRtVersion.equals(anotherRtVersion) || anotherRtVersion != null && !anotherRtVersion.equals(currentRtVersion)) {
                            slotter = this.m_incompatibleSlotterMgr.get(anotherRtVersion);
                        }
                    }
                    slotter.addSlotAssignment(exportJsSlotter.getJsSlotAssignment());
                }
                JsResourceAggregator.aggregate((IExportJsResource)resource, (JsResourceSlotter)slotter, exclusion);
            }
        }
    }

    private void aggregateContext(ResourceCtx context, ResourceSpecCollector specCollector, Set<String> exclusion) {
        Iterator specs = context.componentSpecIterator();
        while (specs.hasNext()) {
            specCollector.aggregate((IResourceSpec)specs.next());
        }
        JsResourceAggregator.aggregate((IResourceSpecs)specCollector, (JsResourceSlotter)this.m_slotter, exclusion);
    }

    public static void aggragateJsForViewSpec(IViewSpec viewSpec, JsResourceSlotter slotter) {
        Permutation permutation = Permutation.getFromCtx();
        ResourceSpecCollector specCollector = new ResourceSpecCollector();
        BaseJsProcessor.aggregateViewSpec(viewSpec, permutation, specCollector, slotter);
    }

    private static Set<String> aggregateViewSpec(IViewSpec viewSpec, Permutation permutation, ResourceSpecCollector specCollector, JsResourceSlotter slotter) {
        Set exclusion = null;
        JsResourceCache cache = null;
        if (!ResourceAggregationControl.getInstance().needToEmbedPageJs()) {
            cache = ViewSpecResourceCacheMgr.getInstance().getJsCache(viewSpec);
        }
        if (cache != null && cache.isCached(permutation)) {
            for (String slotName : cache.getJsSlotNames(permutation)) {
                IJsResourceRef ref = cache.getJsRef(permutation, slotName);
                ((JsResourceSlot)slotter.getSlot(slotName)).add((IResourceRef)ref);
            }
            return cache.getCachedJsSet(permutation);
        }
        specCollector.aggregate((IResourceSpec)viewSpec.getComponentSpec());
        JsResourceAggregator.aggregate((IResourceSpecs)specCollector, (JsResourceSlotter)slotter, exclusion);
        return null;
    }

    public JsResourceSlotter createSlotter() {
        SimpleJsResourceSlotter slotter = new SimpleJsResourceSlotter(false);
        slotter.addSlotAssignment(this.createAssignment());
        return slotter;
    }

    public JsResourceSlotAssignment createAssignment() {
        return new JsResourceSlotAssignment();
    }

    protected static void assignJsSlot(JsResourceSlotAssignment assignment, IComponentSpec rootSpec, String slotName) {
        ResourceSpecCollector specCollector = new ResourceSpecCollector();
        specCollector.aggregate((IResourceSpec)rootSpec);
        for (IResourceSpec spec : specCollector) {
            for (IJsResourceRef resource : spec.getClassDefinitions()) {
                if (assignment.hasAssignment(resource)) continue;
                assignment.put(resource, slotName);
            }
            for (IJsResourceRef resource : spec.getExecutingScript()) {
                if (assignment.hasAssignment(resource)) continue;
                assignment.put(resource, slotName);
            }
        }
    }

    protected static void assignJsSlot(JsResourceSlotAssignment assignment, String urnPrefix, String slotName) {
        assignment.put(urnPrefix, slotName);
    }

    private class IncompatibleJsSlotterMgr {
        private JsResourceSlotter m_nonScopedSlotter = null;
        private Map<String, JsResourceSlotter> m_scopedSlotters = null;

        private IncompatibleJsSlotterMgr() {
        }

        JsResourceSlotter get(String version) {
            JsResourceSlotter slotter;
            if (version == null) {
                if (this.m_nonScopedSlotter == null) {
                    this.m_nonScopedSlotter = BaseJsProcessor.this.m_slotter.cloneAnEmptySlotter();
                }
                return this.m_nonScopedSlotter;
            }
            if (this.m_scopedSlotters == null) {
                this.m_scopedSlotters = new HashMap<String, JsResourceSlotter>(2);
            }
            if ((slotter = this.m_scopedSlotters.get(version)) == null) {
                slotter = BaseJsProcessor.this.m_slotter.cloneAnEmptySlotter();
                slotter.setRuntimeVersion(version);
                this.m_scopedSlotters.put(version, slotter);
            }
            return slotter;
        }

        void apply(DDocument doc) {
            if (this.m_nonScopedSlotter != null) {
                BaseJsProcessor.this.m_applier.apply(doc, this.m_nonScopedSlotter, !this.isEmpty());
            }
            if (this.m_scopedSlotters != null) {
                for (JsResourceSlotter slotter : this.m_scopedSlotters.values()) {
                    BaseJsProcessor.this.m_applier.apply(doc, slotter, !this.isEmpty());
                }
            }
        }

        boolean isEmpty() {
            if (this.m_scopedSlotters == null) {
                return true;
            }
            return this.m_scopedSlotters.isEmpty();
        }
    }
}

