/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.meta;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.resource.slot.ExternalizedSlotGrouping;
import org.eclipse.vjet.vsf.aggregator.cache.meta.AppJsExternalizationInfo;
import org.eclipse.vjet.vsf.aggregator.cache.meta.BaseExternalizationInfoBuilder;
import org.eclipse.vjet.vsf.aggregator.cache.meta.ViewJsExternalizationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JsExternalizationInfoBuilder
extends BaseExternalizationInfoBuilder {
    private static final String SLOT_TAG = "Slot";
    private static final String MAPPING_TAG = "Mapping";
    private static final String INDEX_ATTR = "group";
    private static final String SLOT_ATTR = "slot";
    private static Logger s_logger;

    public static String buildXml(AppJsExternalizationInfo appJsInfo) {
        StringBuilder sb = new StringBuilder();
        JsExternalizationInfoBuilder.addDocument(sb);
        JsExternalizationInfoBuilder.openStartTag("app", sb);
        JsExternalizationInfoBuilder.addAttribute("id", appJsInfo.getAppId(), sb);
        JsExternalizationInfoBuilder.addAttribute("buildid", appJsInfo.getBuildId(), sb);
        JsExternalizationInfoBuilder.closeStartTag(sb, true);
        for (ViewJsExternalizationInfo viewJsInfo : appJsInfo.getAllViewJsInfos()) {
            JsExternalizationInfoBuilder.openStartTag("view", sb);
            JsExternalizationInfoBuilder.addAttribute("id", viewJsInfo.getViewId(), sb);
            JsExternalizationInfoBuilder.closeStartTag(sb, true);
            for (Map.Entry entry : viewJsInfo.getSlotGroupping().getAllMappings().entrySet()) {
                JsExternalizationInfoBuilder.openStartTag(MAPPING_TAG, sb);
                JsExternalizationInfoBuilder.addAttribute(SLOT_ATTR, (String)entry.getKey(), sb);
                JsExternalizationInfoBuilder.addAttribute(INDEX_ATTR, (String)entry.getValue(), sb);
                JsExternalizationInfoBuilder.closeFullTag(sb, true);
            }
            JsExternalizationInfoBuilder.writeUrns(viewJsInfo.getAllGrouppedJsInfo(), sb);
            for (String locale : viewJsInfo.getLocales()) {
                JsExternalizationInfoBuilder.openStartTag("locale", sb);
                JsExternalizationInfoBuilder.addAttribute("name", locale, sb);
                JsExternalizationInfoBuilder.closeStartTag(sb, true);
                JsExternalizationInfoBuilder.writeUrns(viewJsInfo.getAllGrouppedJsInfo(locale), sb);
                JsExternalizationInfoBuilder.endTag("locale", sb);
            }
            JsExternalizationInfoBuilder.endTag("view", sb);
        }
        JsExternalizationInfoBuilder.endTag("app", sb);
        return sb.toString();
    }

    private static void writeUrns(Collection<ViewJsExternalizationInfo.GrouppedJsInfo> group, StringBuilder sb) {
        for (ViewJsExternalizationInfo.GrouppedJsInfo slotJsInfo : group) {
            JsExternalizationInfoBuilder.openStartTag(SLOT_TAG, sb);
            JsExternalizationInfoBuilder.addAttribute(INDEX_ATTR, slotJsInfo.getIndex(), sb);
            JsExternalizationInfoBuilder.addAttribute("path", slotJsInfo.getRelativePath(), sb);
            JsExternalizationInfoBuilder.addAttribute("opath", slotJsInfo.getOptimizedPath(), sb);
            JsExternalizationInfoBuilder.addAttribute("md5", slotJsInfo.getMd5(), sb);
            JsExternalizationInfoBuilder.addAttribute("default_size", slotJsInfo.getResourceSize(), sb);
            JsExternalizationInfoBuilder.closeStartTag(sb, true);
            for (String urn : slotJsInfo.getAllJsResourceUrns()) {
                JsExternalizationInfoBuilder.openStartTag("ref", sb);
                JsExternalizationInfoBuilder.addAttribute("urn", urn, sb);
                String size = slotJsInfo.getJsResourceSize(urn);
                JsExternalizationInfoBuilder.addAttribute("default_size", size, sb);
                ViewJsExternalizationInfo.GrouppedJsInfo.MARKER marker = slotJsInfo.getJsResourceUrnMarker(urn);
                if (ViewJsExternalizationInfo.GrouppedJsInfo.MARKER.EXCLUDE.equals((Object)marker)) {
                    JsExternalizationInfoBuilder.addAttribute("marker", ViewJsExternalizationInfo.GrouppedJsInfo.MARKER.EXCLUDE.toString(), sb);
                }
                JsExternalizationInfoBuilder.closeFullTag(sb, true);
            }
            JsExternalizationInfoBuilder.endTag(SLOT_TAG, sb);
        }
    }

    public static AppJsExternalizationInfo parse(InputStream is) {
        JsInfoSaxHandler handler = new JsInfoSaxHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        return handler.getAppJsInfo();
    }

    public static AppJsExternalizationInfo parse(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return JsExternalizationInfoBuilder.parse(bais);
    }

    private static Logger getLogger() {
        if (s_logger != null) {
            return s_logger;
        }
        s_logger = Logger.getInstance(JsExternalizationInfoBuilder.class);
        return s_logger;
    }

    private static class JsInfoSaxHandler
    extends DefaultHandler {
        private AppJsExternalizationInfo m_appJsInfo;
        private ViewJsExternalizationInfo m_viewJsInfo;
        private ViewJsExternalizationInfo.GrouppedJsInfo m_slottedJsInfo;
        private String m_locale;

        private JsInfoSaxHandler() {
        }

        AppJsExternalizationInfo getAppJsInfo() {
            return this.m_appJsInfo;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String id;
            super.startElement(uri, localName, qName, attributes);
            if ("ref".equals(qName)) {
                if (this.m_slottedJsInfo == null) {
                    throw new DsfRuntimeException("Missing parent Slot element");
                }
                String urn = JsExternalizationInfoBuilder.getAttribute("urn", attributes, "ref");
                if (attributes.getIndex("marker") != -1) {
                    String marker = JsExternalizationInfoBuilder.getAttribute("marker", attributes, "ref");
                    if (ViewJsExternalizationInfo.GrouppedJsInfo.MARKER.EXCLUDE.toString().equals(marker)) {
                        this.m_slottedJsInfo.addJsResourceUrn(urn, ViewJsExternalizationInfo.GrouppedJsInfo.MARKER.EXCLUDE);
                    }
                } else {
                    this.m_slottedJsInfo.addJsResourceUrn(urn);
                }
                if (attributes.getIndex("default_size") != -1) {
                    String size = JsExternalizationInfoBuilder.getAttribute("default_size", attributes, "ref");
                    this.m_slottedJsInfo.addJsResourceSize(urn, size);
                }
            }
            if (JsExternalizationInfoBuilder.SLOT_TAG.equals(qName)) {
                if (this.m_viewJsInfo == null) {
                    throw new DsfRuntimeException("Missing parent view element");
                }
                String index = JsExternalizationInfoBuilder.getAttribute(JsExternalizationInfoBuilder.INDEX_ATTR, attributes, JsExternalizationInfoBuilder.SLOT_TAG);
                this.m_slottedJsInfo = this.m_locale == null ? this.m_viewJsInfo.getGrouppedJsInfo(index) : this.m_viewJsInfo.getGrouppedJsInfo(index, this.m_locale);
                String path = JsExternalizationInfoBuilder.getAttribute("path", attributes, JsExternalizationInfoBuilder.SLOT_TAG);
                this.m_slottedJsInfo.setRelativePath(path);
                try {
                    String oPath = JsExternalizationInfoBuilder.getAttribute("opath", attributes, JsExternalizationInfoBuilder.SLOT_TAG);
                    this.m_slottedJsInfo.setOptimizedPath(oPath);
                    String md5 = JsExternalizationInfoBuilder.getAttribute("md5", attributes, JsExternalizationInfoBuilder.SLOT_TAG);
                    this.m_slottedJsInfo.setMd5(md5);
                    if (attributes.getIndex("default_size") != -1) {
                        String size = JsExternalizationInfoBuilder.getAttribute("default_size", attributes, JsExternalizationInfoBuilder.SLOT_TAG);
                        this.m_slottedJsInfo.setResourceSize(size);
                    }
                }
                catch (Exception exception) {
                    JsExternalizationInfoBuilder.getLogger().log(LogLevel.WARN, "md5 or opath not defined");
                }
            } else if (JsExternalizationInfoBuilder.MAPPING_TAG.equals(qName)) {
                if (this.m_viewJsInfo == null) {
                    throw new DsfRuntimeException("Missing parent app element");
                }
                String slotName = JsExternalizationInfoBuilder.getAttribute(JsExternalizationInfoBuilder.SLOT_ATTR, attributes, JsExternalizationInfoBuilder.MAPPING_TAG);
                String index = JsExternalizationInfoBuilder.getAttribute(JsExternalizationInfoBuilder.INDEX_ATTR, attributes, JsExternalizationInfoBuilder.MAPPING_TAG);
                this.m_viewJsInfo.getSlotGroupping().put(slotName, index);
            } else if ("view".equals(qName)) {
                if (this.m_appJsInfo == null) {
                    throw new DsfRuntimeException("Missing parent app element");
                }
                id = JsExternalizationInfoBuilder.getAttribute("id", attributes, "view");
                this.m_viewJsInfo = new ViewJsExternalizationInfo(id);
                this.m_viewJsInfo.setSlotMapping(new ExternalizedSlotGrouping());
                this.m_appJsInfo.addViewJsInfo(this.m_viewJsInfo);
            } else if ("app".equals(qName)) {
                id = JsExternalizationInfoBuilder.getAttribute("id", attributes, "app");
                String buildId = JsExternalizationInfoBuilder.getAttribute("buildid", attributes, "app");
                this.m_appJsInfo = new AppJsExternalizationInfo(id, buildId);
            } else if ("locale".equals(qName)) {
                this.m_locale = JsExternalizationInfoBuilder.getAttribute("name", attributes, JsExternalizationInfoBuilder.MAPPING_TAG);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("view".equals(qName)) {
                this.m_viewJsInfo = null;
            } else if (JsExternalizationInfoBuilder.SLOT_TAG.equals(qName)) {
                this.m_slottedJsInfo = null;
            }
        }
    }
}

