/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.js;

import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.resource.slot.ScriptType;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.dsf.spec.export.IExportJsResource;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpecs;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRef;

public class JsResourceAggregator {
    public static void aggregate(IResourceSpecs<? extends IResourceSpec> specs, JsResourceSlotter slotter) {
        JsResourceAggregator.aggregate(specs, slotter, null);
    }

    public static void aggregate(IResourceSpecs<? extends IResourceSpec> specs, JsResourceSlotter slotter, Set<String> exclusion) {
        if (specs == null) {
            throw new DsfRuntimeException("specs is null");
        }
        for (IResourceSpec spec : specs) {
            JsResourceAggregator.aggregate((IExportJsResource)spec, slotter, exclusion);
        }
    }

    public static void aggregate(IExportJsResource exptResource, JsResourceSlotter slotter) {
        if (exptResource == null) {
            throw new DsfRuntimeException("exptResource is null");
        }
        JsResourceAggregator.aggregate(exptResource, slotter, null);
    }

    public static void aggregate(IExportJsResource exptResource, JsResourceSlotter slotter, Set<String> exclusion) {
        for (IJsResourceRef resource : exptResource.getClassDefinitions()) {
            if (JsResourceAggregator.shouldExclude(resource, exclusion)) continue;
            slotter.addToSlot(resource, ScriptType.ClassDefinition);
            if (!ResourceUsageCtx.ctx().isNeedinlineInfo() || slotter.getResourceReplacement() == null || slotter.getResourceReplacement().contains(resource) || !(resource instanceof JsResourceRef) || ((JsResourceRef)resource).isTextadapter()) continue;
            ResourceUsageCtx.ctx().setInlinedUrns(resource.getUrn());
        }
        for (IJsResourceRef resource : exptResource.getExecutingScript()) {
            if (JsResourceAggregator.shouldExclude(resource, exclusion)) continue;
            slotter.addToSlot(resource, ScriptType.ExecutingScript);
            if (!ResourceUsageCtx.ctx().isNeedinlineInfo() || slotter.getResourceReplacement() == null || slotter.getResourceReplacement().contains(resource) || ((JsResourceRef)resource).isTextadapter()) continue;
            ResourceUsageCtx.ctx().setInlinedUrns(resource.getUrn());
        }
    }

    private static boolean shouldExclude(IJsResourceRef resource, Set<String> exclusion) {
        if (exclusion == null) {
            return false;
        }
        return exclusion.contains(resource.getUrn());
    }
}

