/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache;

import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.spec.app.IAppSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vsf.aggregator.cache.IExternalizationPath;

public class VersionedExternalizationPath
implements IExternalizationPath {
    private final String m_majorVer;
    private final String m_minorVer;

    public VersionedExternalizationPath() {
        this.m_majorVer = "v";
        this.m_minorVer = "";
    }

    public VersionedExternalizationPath(String majorVer, String minorVer) {
        this.m_majorVer = majorVer;
        this.m_minorVer = minorVer;
    }

    public String getMajorVersion() {
        return this.m_majorVer;
    }

    public String getMinorVersion() {
        return this.m_minorVer;
    }

    @Override
    public String getRelativePath(Permutation permutation, IAppSpec appSpec, IViewSpec viewSpec) {
        return this.getRelativePath(permutation, appSpec, viewSpec, null);
    }

    @Override
    public String getRelativePath(Permutation permutation, IAppSpec appSpec, IViewSpec viewSpec, String index) {
        return this.getRelativePath(permutation, this.getRelativePath(appSpec, viewSpec, index));
    }

    @Override
    public String getRelativePath(Permutation permutation, String subPath) {
        StringBuilder sb = new StringBuilder(60);
        String localeStr = permutation.getLocale().toString();
        if (permutation.isLanguageSpecific()) {
            localeStr = String.valueOf(permutation.getParent().getLocale().toString()) + "__" + localeStr;
        }
        sb.append(localeStr);
        if (permutation.getTarget() != null && !Permutation.isDefaultTarget((String)permutation.getTarget())) {
            sb.append("/");
            sb.append(permutation.getTarget());
        }
        sb.append("/").append(subPath).append("_").append(localeStr);
        return sb.toString();
    }

    @Override
    public String getRelativePath(IAppSpec appSpec, IViewSpec viewSpec) {
        return this.getRelativePath(appSpec, viewSpec, null);
    }

    @Override
    public String getRelativePath(IAppSpec appSpec, IViewSpec viewSpec, String index) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.m_majorVer).append("/").append(appSpec.getName()).append("_").append(viewSpec.getName()).append("_").append(this.m_majorVer).append(this.m_minorVer.replaceAll(":", "_"));
        if (index != null && index.length() > 0) {
            sb.append("_").append(index);
        }
        return sb.toString();
    }

    @Override
    public String getRelativePath(IAppSpec appSpec, String index) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.m_majorVer).append("/").append(appSpec.getName()).append("_").append("Common").append("_").append(this.m_majorVer).append(this.m_minorVer);
        if (index != null && index.length() > 0) {
            sb.append("_").append(index);
        }
        return sb.toString();
    }

    @Override
    public String getRelativePath(Permutation permutation, IAppSpec appSpec, String index) {
        return this.getRelativePath(permutation, this.getRelativePath(appSpec, index));
    }
}

