/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ResourceExternalizationHelper {
    public static final String ENCODING = "UTF-8";
    public static final String Z_FOLDER = "z";
    public static final int VERSION = 0;

    public static String getZFolderName(String aggId) {
        int len = aggId.length();
        String part1 = aggId.substring(0, len - 2);
        String part2 = aggId.substring(len - 2);
        StringBuilder result = new StringBuilder();
        result.append(Z_FOLDER);
        result.append("/");
        result.append(part2);
        result.append("/");
        result.append(part1);
        return result.toString();
    }

    public static File create(File rootDir, String path) throws IOException {
        File file = new File(rootDir, path);
        ResourceExternalizationHelper.create(file);
        return file;
    }

    public static void saveToFile(String text, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            os.write(text.getBytes(ENCODING));
            os.flush();
        }
        finally {
            os.close();
        }
    }

    public static void create(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }
}

