/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.CallerIntrospector;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.environment.CommonResourceGroups;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.slot.ExternalizedSlotGrouping;
import org.eclipse.vjet.dsf.resource.slot.IJsResourceReplacement;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.dsf.resource.utils.ResourceUtil;
import org.eclipse.vjet.dsf.resource.x.IResourceAggregationModeResolver;
import org.eclipse.vjet.dsf.spec.app.IAppSpec;
import org.eclipse.vjet.dsf.spec.collector.ResourceSpecCollector;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vjo.VjBootstrapJsr;
import org.eclipse.vjet.vsf.aggregator.cache.IExternalizationPath;
import org.eclipse.vjet.vsf.aggregator.cache.ResourceAggregationControl;
import org.eclipse.vjet.vsf.aggregator.cache.ResourceExternalizationHelper;
import org.eclipse.vjet.vsf.aggregator.cache.meta.AppJsExternalizationInfo;
import org.eclipse.vjet.vsf.aggregator.cache.meta.GrouppedBaseInfo;
import org.eclipse.vjet.vsf.aggregator.cache.meta.ViewJsExternalizationInfo;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResRtCfg;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;
import org.eclipse.vjet.vsf.resource.pattern.js.OnFlyJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.VjoBootstrapJsResourceProxy;

public class JsSystemLibCache
extends OnFlyJsResourceDispenser
implements IJsResourceReplacement {
    private Set<String> m_cachedResources = new HashSet<String>(6);
    private Map<String, IJsResourceRef> m_contentCache = new HashMap<String, IJsResourceRef>(6);
    private JsResourceSlotAssignment m_jsSlotAssignment = new JsResourceSlotAssignment();
    private Map<String, IJsResourceRef> m_externalRefMapping = new HashMap<String, IJsResourceRef>(6);
    private static JsSystemLibCache s_default = new JsSystemLibCache();
    private IJsResourceRef m_bootStrapVariationRef = null;

    public static JsSystemLibCache getDefault() {
        return s_default;
    }

    public static void setDefault(JsSystemLibCache instance) {
        s_default = instance;
    }

    public JsResourceSlotAssignment getJsSlotAssignment() {
        return this.m_jsSlotAssignment;
    }

    public void setJsSlotAssignment(JsResourceSlotAssignment jsSlotAssignment) {
        this.m_jsSlotAssignment = jsSlotAssignment;
    }

    public void addAppSpecToSysLib(IAppSpec sysAppSpec) {
        for (IViewSpec viewSpec : sysAppSpec.getAllViewSpecs()) {
            JsResourceSlotAssignment viewSlots = viewSpec.getJsSlotAssignment();
            ResourceSpecCollector collector = new ResourceSpecCollector();
            collector.aggregate((IResourceSpec)viewSpec.getComponentSpec());
            for (IResourceSpec resourceSpec : collector) {
                for (IJsResourceRef ref : resourceSpec.getClassDefinitions()) {
                    if (this.contains(ref)) continue;
                    this.addEmbeddedJs(ref, viewSlots.getSlotName(ref));
                }
            }
        }
    }

    public void addEmbeddedJs(IJsResourceRef resource) {
        String urn = resource.getUrn();
        if (this.m_contentCache.containsKey(urn)) {
            return;
        }
        this.m_contentCache.put(urn, resource);
        this.m_cachedResources.add(urn);
    }

    public void addEmbeddedJs(IJsResourceRef resource, String slotName) {
        this.addEmbeddedJs(resource);
        if (slotName != null) {
            this.m_jsSlotAssignment.put(resource, slotName);
        }
    }

    public IJsResourceRef getEmbedableJs(IJsResourceRef resource) {
        return this.m_contentCache.get(resource.getUrn());
    }

    public void addExternalRefMapping(IJsResourceRef resource, IJsResourceRef extrenalRef) {
        this.m_externalRefMapping.put(resource.getUrn(), extrenalRef);
        this.m_cachedResources.add(resource.getUrn());
    }

    protected void setExternalRefMapping(Map<String, IJsResourceRef> externalRefMapping) {
        this.m_externalRefMapping = externalRefMapping;
        for (String urn : externalRefMapping.keySet()) {
            this.m_cachedResources.add(urn);
        }
    }

    public IJsResourceRef getExternalRef(IJsResourceRef resource) {
        if (ResourceAggregationControl.getInstance().needToEmbedSysJs()) {
            return null;
        }
        return this.m_externalRefMapping.get(resource.getUrn());
    }

    public void updateExternalizedRefs(URL baseUrl, URL secureBaseUrl, IExternalizationPath path, IViewSpec viewSpec, ViewJsExternalizationInfo viewJsInfo) {
        this.updateExternalizedRefs(baseUrl, secureBaseUrl, path, viewSpec, viewJsInfo, null);
    }

    public void updateExternalizedRefs(URL baseUrl, URL secureBaseUrl, IExternalizationPath path, IViewSpec viewSpec, ViewJsExternalizationInfo viewJsInfo, AppJsExternalizationInfo appInfo) {
        ExternalizedSlotGrouping mapping = viewJsInfo.getSlotGroupping();
        for (ViewJsExternalizationInfo.GrouppedJsInfo groupInfo : viewJsInfo.getAllGrouppedJsInfo()) {
            String groupIndex = groupInfo.getIndex();
            List slotNames = mapping.getSlotNames(groupIndex);
            int idx = 0;
            while (idx < slotNames.size()) {
                int index = ((String)slotNames.get(idx)).indexOf("_ClassDefinition");
                if (index >= 0) {
                    String slotName = ((String)slotNames.get(idx)).substring(0, index);
                    IJsResourceRef ref = JsSystemLibCache.jsRef(JsSystemLibCache.viaGroupInfo(groupInfo, appInfo, baseUrl, secureBaseUrl, path), JsType.DefAndInit);
                    if (viewSpec.isJsSystemLibVariation()) {
                        for (String urn : groupInfo.getAllJsResourceUrns()) {
                            if (!VjBootstrapJsr.URN.equals(urn)) continue;
                            this.m_bootStrapVariationRef = ref;
                            return;
                        }
                    }
                    boolean hasVjBootstrap = false;
                    for (String urn : groupInfo.getAllJsResourceUrns()) {
                        if (VjBootstrapJsr.URN.equals(urn)) {
                            hasVjBootstrap = true;
                        }
                        if (this.m_bootStrapVariationRef != null && hasVjBootstrap) {
                            VjoBootstrapJsResourceProxy proxy = new VjoBootstrapJsResourceProxy(ref, this.m_bootStrapVariationRef);
                            this.addEmbeddedJs(JsSystemLibCache.jsRef(JsSystemLibCache.viaExternalizedRef(urn, ref), JsType.DefAndInit), slotName);
                            this.m_externalRefMapping.put(urn, (IJsResourceRef)proxy);
                            continue;
                        }
                        this.addEmbeddedJs(JsSystemLibCache.jsRef(JsSystemLibCache.viaExternalizedRef(urn, ref), JsType.DefAndInit), slotName);
                        this.m_externalRefMapping.put(urn, ref);
                    }
                }
                ++idx;
            }
        }
    }

    public Map<String, IJsResourceRef> getCachedRefs() {
        return this.m_contentCache;
    }

    public IJsResourceRef getCachedRef(String resource) {
        return this.m_contentCache.get(resource);
    }

    public IJsResourceRef getCachedRef(IJsResourceRef resource) {
        IJsResourceRef ref = this.getExternalRef(resource);
        if (ref == null) {
            ref = this.m_contentCache.get(resource.getUrn());
        }
        return ref;
    }

    public IJsResourceRef getReplacement(IJsResourceRef resource) {
        return this.getCachedRef(resource);
    }

    public boolean contains(IJsResourceRef resource) {
        return this.m_cachedResources.contains(resource.getUrn());
    }

    public Set<String> getCachedResourceUrns() {
        return this.m_cachedResources;
    }

    public void clearCache() {
        this.m_cachedResources = new HashSet<String>(6);
        this.m_contentCache = new HashMap<String, IJsResourceRef>(6);
        this.m_externalRefMapping = new HashMap<String, IJsResourceRef>(6);
        this.m_jsSlotAssignment = new JsResourceSlotAssignment();
    }

    protected static IJsResourceRef jsRef(JsResource resource, JsType type) {
        return JsSystemLibCache.jsRef((JsResource)resource, JsSystemLibCache.class, (JsType)type);
    }

    protected static JsResource viaGroupInfo(GrouppedBaseInfo groupInfo, AppJsExternalizationInfo appInfo, URL baseUrl, URL secureBaseUrl, IExternalizationPath pathGenerator) {
        String urn = groupInfo.getRelativePath();
        String hint = groupInfo.getRelativePath();
        return new JsResource(CallerIntrospector.getCallingClass(), urn, urn, (JsResource.IHandleProvider)new UrlOnlyHandleProvider(groupInfo.getRelativePath(), groupInfo.getOptimizedPath(), groupInfo.getNonSecureAggResId(), groupInfo.getSecureAggResId(), hint, baseUrl, secureBaseUrl, pathGenerator), CommonResourceGroups.JS.getId());
    }

    protected static JsResource viaGroupInfo(GrouppedBaseInfo groupInfo, URL baseUrl, URL secureBaseUrl, IExternalizationPath pathGenerator) {
        return JsSystemLibCache.viaGroupInfo(groupInfo, null, baseUrl, secureBaseUrl, pathGenerator);
    }

    protected static JsResource viaExternalizedRef(String urn, IJsResourceRef ref) {
        String externalizedRef = ref.getUrn().concat("/").concat(urn);
        return new JsResource(CallerIntrospector.getCallingClass(), externalizedRef, urn, (JsResource.IHandleProvider)new ExternalizedRefHandleAdapter(), CommonResourceGroups.JS.getId());
    }

    private static class ExternalizedRefHandleAdapter
    implements JsResource.IHandleProvider,
    IJsResourceHandle {
        private ExternalizedRefHandleAdapter() {
        }

        public IJsResourceHandle getHandle(Permutation permutationCtx) {
            return this;
        }

        public URL getExternalUrl() {
            return null;
        }

        public boolean isExternalized() {
            return false;
        }

        public String getScriptText() {
            return null;
        }
    }

    private static class UrlOnlyHandleProvider
    implements JsResource.IHandleProvider {
        private final String m_uri;
        private final String m_optimizedUri;
        private final String m_aggId;
        private final String m_secureAggId;
        private final String m_desc;
        private final URL m_baseUrl;
        private final URL m_secureBaseUrl;
        private final IExternalizationPath m_pathGenerator;

        private UrlOnlyHandleProvider(String uri, String optimizedUri, String aggId, String secureAggId, String desc, URL baseUrl, URL secureBaseUrl, IExternalizationPath pathGenerator) {
            this.m_uri = uri;
            this.m_optimizedUri = optimizedUri;
            this.m_aggId = aggId;
            this.m_secureAggId = secureAggId;
            this.m_desc = desc;
            this.m_baseUrl = baseUrl;
            this.m_secureBaseUrl = secureBaseUrl;
            this.m_pathGenerator = pathGenerator;
        }

        public IJsResourceHandle getHandle(Permutation permutation) {
            return new UrlOnlyResourceHandle(permutation);
        }

        protected class UrlOnlyResourceHandle
        implements IJsResourceHandle {
            private final Permutation m_permutation;
            private static final String SUFFIX = ".js";

            private UrlOnlyResourceHandle(Permutation permutation) {
                this.m_permutation = permutation;
            }

            public boolean isExternalized() {
                return true;
            }

            public URL getExternalUrl() {
                URL resultUrl;
                String path = null;
                boolean isSecure = DsfCtx.ctx().isSecureRequest();
                IResourceAggregationModeResolver.AggregationMode mode = JsResRtCfg.getInstance().getAggregationMode();
                if ((mode == IResourceAggregationModeResolver.AggregationMode.RUNTIME || mode == IResourceAggregationModeResolver.AggregationMode.DYNAMIC || mode == IResourceAggregationModeResolver.AggregationMode.TRANSITION) && UrlOnlyHandleProvider.this.m_aggId != null) {
                    String userAgent;
                    path = isSecure && UrlOnlyHandleProvider.this.m_secureAggId != null ? ResourceExternalizationHelper.getZFolderName(UrlOnlyHandleProvider.this.m_secureAggId) : ResourceExternalizationHelper.getZFolderName(UrlOnlyHandleProvider.this.m_aggId);
                    path = String.valueOf(path) + SUFFIX;
                    if (UrlOnlyHandleProvider.this.m_desc != null && ((userAgent = DsfCtx.ctx().getUserAgent()) == null || !userAgent.contains("MSIE 6.") && !userAgent.contains("BlackBerry"))) {
                        path = String.valueOf(path) + UrlOnlyHandleProvider.this.m_desc.replace(Permutation.getDefault().toExternal(), this.m_permutation.toExternal());
                    }
                } else {
                    path = ResourceUsageCtx.ctx().isUseOptimizedExternalPaths() && UrlOnlyHandleProvider.this.m_optimizedUri != null ? String.valueOf(UrlOnlyHandleProvider.this.m_pathGenerator.getRelativePath(this.m_permutation, UrlOnlyHandleProvider.this.m_optimizedUri)) + SUFFIX : String.valueOf(UrlOnlyHandleProvider.this.m_pathGenerator.getRelativePath(this.m_permutation, UrlOnlyHandleProvider.this.m_uri)) + SUFFIX;
                }
                try {
                    resultUrl = isSecure ? new URL(UrlOnlyHandleProvider.this.m_secureBaseUrl, path) : new URL(UrlOnlyHandleProvider.this.m_baseUrl, path);
                }
                catch (MalformedURLException e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                resultUrl = ResourceUtil.modify((URL)resultUrl, (IResourceAggregationModeResolver.AggregationMode)mode);
                return resultUrl;
            }

            public String getScriptText() {
                throw new DsfRuntimeException("Not implemented");
            }
        }
    }
}

