/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DDiv;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.NativeEvent;
import org.w3c.dom.Node;

public class DLCClientHelper {
    public static final byte[] DLC_JS = DLCClientHelper.getData("DSFLiveConnect.js");
    public static final byte[] DLC_SWF = DLCClientHelper.getData("DSFLiveConnect.swf");
    public static final String DLC_OBJ_ID = "DLC_OBJ";
    private static final String DLC_SESSION_ID = "DLC_SID";

    public static void enableDLC(String dlcHost, int port, DHtmlDocument doc, IDLCClient dlcClient) {
        String js = "var DLC_HOST='" + dlcHost + "'; " + "var DLC_PORT=" + port + ";";
        doc.getHead().add((DNode)DLCClientHelper.createScriptWithText(js));
        String dlcUrl = "http://" + dlcHost + ":" + port + "/";
        doc.getHead().add((DNode)DLCClientHelper.createScriptWithSrc(String.valueOf(dlcUrl) + "DLC_JS.js"));
        doc.getBody().insertBefore((Node)new DDiv().setHtmlId(DLC_OBJ_ID).setHtmlStyleAsString("width:1px;height:1px;position:absolute;left:-1000px;").add((DNode)DLCClientHelper.createScriptWithSrc(String.valueOf(dlcUrl) + "DLC_CLIENT_JS.js")), doc.getBody().getFirstChild());
    }

    public static String getSessionId(HttpServletRequest request) {
        if (request.getCookies() == null) {
            return null;
        }
        Cookie[] cookieArray = request.getCookies();
        int n = cookieArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie c = cookieArray[n2];
            if (DLC_SESSION_ID.equals(c.getName())) {
                return c.getValue();
            }
            ++n2;
        }
        return null;
    }

    public static String getRequestId(HttpServletRequest request) {
        return null;
    }

    public static void setSessionId(HttpServletResponse response, String sessionId) {
        response.addCookie(new Cookie(DLC_SESSION_ID, sessionId));
    }

    public static String dlcClientEventEnablerById(String id, NativeEvent event, IDLCClient dlcClient) {
        return DLCClientHelper.dlcClientEventEnablerViaPath("document.getElementById(" + id + ")", event, dlcClient);
    }

    public static String dlcClientEventEnablerViaPath(String path, NativeEvent event, IDLCClient dlcClient) {
        if (event.equals((Object)NativeEvent.imageload)) {
            return "DLC_bindImageLoad(" + path + ")";
        }
        if (event.equals((Object)NativeEvent.scriptLoad)) {
            return "DLC_bindScriptLoad(" + path + ")";
        }
        if (event.equals((Object)NativeEvent.scriptReadyStateChange)) {
            return "DLC_bindScriptReadyStateChange(" + path + ")";
        }
        String code = dlcClient.getDlcEventHandler(event);
        if (code != null) {
            return String.valueOf(path) + ".on" + event.name() + "=" + code;
        }
        return null;
    }

    private static byte[] getData(String resourceName) {
        byte[] buffer = new byte[1024];
        int numRead = 0;
        try {
            InputStream is = ResourceUtil.getResourceAsStream(DLCClientHelper.class, (String)resourceName);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((numRead = is.read(buffer)) > 0) {
                os.write(buffer, 0, numRead);
            }
            is.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private static DScript createScriptWithText(String js) {
        DScript elem = new DScript().setHtmlText(js);
        elem.setAttribute("dlc", "true");
        return elem;
    }

    private static DScript createScriptWithSrc(String src) {
        DScript elem = new DScript().setHtmlSrc(src);
        elem.setAttribute("dlc", "true");
        return elem;
    }
}

