/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.net.URL;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.vjet.dsf.active.util.HtmlBuilderHelper;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DImg;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.IEEventType;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.html.js.JSWindow;

public class JsHackDetectionCtx {
    private StringBuilder m_locationChange = null;
    private boolean m_cookieAccessing = false;
    private boolean m_scriptHacking = false;
    private static ThreadLocalContext s_context = new ThreadLocalContext();

    public static JsHackDetectionCtx ctx() {
        return (JsHackDetectionCtx)s_context.get();
    }

    public static void setCtx(JsHackDetectionCtx context) {
        s_context.set(context);
    }

    public void reset() {
        this.m_locationChange = null;
        this.m_cookieAccessing = false;
        this.m_scriptHacking = false;
        ActiveJsExecutionControlCtx jsControlCtx = ActiveJsExecutionControlCtx.ctx();
        jsControlCtx.setExecuteJavaScript(false);
        jsControlCtx.setParseGeneratedContent(false);
    }

    public String getLocationChange() {
        return this.m_locationChange == null ? null : this.m_locationChange.toString();
    }

    public boolean hasCookieAccessing() {
        return this.m_cookieAccessing;
    }

    public boolean hasScriptHacking() {
        return this.m_scriptHacking;
    }

    public void setLocationChange(String value) {
        if (this.m_locationChange == null) {
            this.m_locationChange = new StringBuilder(value.length() + 2);
        }
        this.m_locationChange.append(value).append("\n");
    }

    public void setCookieAccessing(boolean value) {
        this.m_cookieAccessing = value;
    }

    public void setScriptHacking(boolean value) {
        this.m_scriptHacking = value;
    }

    public void enableJsHackDetection() {
        ActiveJsExecutionControlCtx jsControlCtx = ActiveJsExecutionControlCtx.ctx();
        jsControlCtx.setExecuteJavaScript(true);
        jsControlCtx.setParseGeneratedContent(true);
    }

    public static JsHackDetectionCtx detectJsHack(URL url) {
        JsHackDetectionCtx ctx = JsHackDetectionCtx.ctx();
        ctx.reset();
        ctx.enableJsHackDetection();
        JSWindow window = HtmlBuilderHelper.parse(url);
        JsHackDetectionCtx.analyzeOtherOnloadScripts(window);
        return ctx;
    }

    public static JsHackDetectionCtx detectJsHack(String src, URL baseUrl) {
        JsHackDetectionCtx ctx = JsHackDetectionCtx.ctx();
        ctx.reset();
        ctx.enableJsHackDetection();
        JSWindow window = HtmlBuilderHelper.parse(src, baseUrl);
        JsHackDetectionCtx.analyzeOtherOnloadScripts(window);
        return ctx;
    }

    private static void analyzeOtherOnloadScripts(JSWindow window) {
        DHtmlDocument doc = window.getHTMLDocument();
        DHtmlCollection images = doc.getImages();
        int size = images.getLength();
        int i = 0;
        while (i < size) {
            DImg image = (DImg)images.item(i);
            String src = image.getHtmlSrc().toLowerCase().trim();
            if (src.startsWith("javascript:")) {
                String script = src.substring(11);
                try {
                    window.executeScript(script);
                }
                catch (Exception exception) {}
            }
            ListIterator itr = EventType.getIterator(EventType.class);
            JsHackDetectionCtx.execEventJs(window, image, itr);
            ListIterator itr2 = IEEventType.getIterator(IEEventType.class);
            JsHackDetectionCtx.execEventJs(window, image, itr2);
            ++i;
        }
    }

    private static void execEventJs(JSWindow window, DImg image, Iterator itr) {
        while (itr.hasNext()) {
            BaseEnum evt = (BaseEnum)itr.next();
            String onerror = image.getAttribute("on" + evt.getName());
            if (onerror == null || onerror.length() <= 0) continue;
            try {
                window.executeScript(onerror);
            }
            catch (Exception exception) {}
        }
    }

    private static class ThreadLocalContext
    extends ThreadLocal<JsHackDetectionCtx> {
        private ThreadLocalContext() {
        }

        @Override
        protected JsHackDetectionCtx initialValue() {
            return new JsHackDetectionCtx();
        }
    }
}

