/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.cnr.IDapCapture;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleProxy;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.JsonTokener;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public class DapConsoleProxy
implements IDapConsoleProxy {
    private DapBrowserEmulator m_emulator;
    private Socket m_socket;
    private PrintWriter m_out;
    private BufferedReader m_in;
    private static final String REMOTE_HOST = "localhost";
    private static final int REMOTE_PORT = 10062;
    private Map<String, ICmdHandler> m_handlers = new HashMap<String, ICmdHandler>();

    public DapConsoleProxy() {
        try {
            this.m_socket = new Socket(REMOTE_HOST, 10062);
        }
        catch (IOException iOException) {
            System.out.println("Can not establish connection to localhost:10062");
        }
    }

    @Override
    public void onLoad(DapSession session) {
        if (this.m_socket == null) {
            return;
        }
        this.sendMsg(this.buildOnloadMsg(session));
    }

    @Override
    public void onUnload(DapSession session) {
        if (this.m_socket == null) {
            return;
        }
        this.sendMsg(this.buildOnunloadMsg(session));
    }

    @Override
    public void setBrowserEmulator(DapBrowserEmulator emulator) {
        this.m_emulator = emulator;
    }

    @Override
    public void run() {
        if (this.m_socket == null) {
            return;
        }
        this.initCmdHandlers();
        try {
            String msg;
            this.m_in = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream()));
            this.m_out = new PrintWriter(new OutputStreamWriter(this.m_socket.getOutputStream()));
            System.out.println("Connected to server localhost:10062");
            while ((msg = this.m_in.readLine()) != null) {
                this.receiveMsg(msg);
            }
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    private String buildOnloadMsg(DapSession session) {
        int end;
        String url = session.getCurrentView().getUrl();
        String dervletName = "DsfDervlet";
        int start = url.indexOf("class=");
        if (start > 0 && (end = (dervletName = url.substring(start + "class=".length())).indexOf("&")) > 0) {
            dervletName = dervletName.substring(0, end);
        }
        String path = "";
        try {
            Class<?> c = Class.forName(dervletName);
            String testPath = JavaSourceLocator.getInstance().getSourceUrl(c).toExternalForm();
            path = new File(testPath).getParent();
            if (path == null) {
                path = "";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        JsonObject jo = new JsonObject();
        jo.accumulate("cmd", (Object)"newsession");
        jo.accumulate("sessionid", (Object)session.getSessionId());
        jo.accumulate("dervletname", (Object)dervletName);
        jo.accumulate("useragent", (Object)session.getUserAgent());
        jo.accumulate("status", (Object)this.getSessionStatus(session));
        jo.accumulate("url", (Object)url);
        jo.accumulate("testcasepath", (Object)path);
        start = url.indexOf("name=");
        if (start > 0) {
            String name = url.substring(start + "name=".length());
            int end2 = dervletName.indexOf("&");
            if (end2 > 0) {
                name = name.substring(0, end2);
            }
            jo.accumulate("name", (Object)name);
        }
        jo.accumulate("timestamp", (Object)String.valueOf(new Date().getTime()));
        return jo.toString();
    }

    private String buildOnunloadMsg(DapSession session) {
        JsonObject jo = new JsonObject();
        jo.accumulate("cmd", (Object)"endsession");
        jo.accumulate("sessiondid", (Object)session.getSessionId());
        return jo.toString();
    }

    private synchronized void sendMsg(String msg) {
        if (this.m_socket == null) {
            return;
        }
        this.m_out.println(msg);
        this.m_out.flush();
    }

    private void receiveMsg(String msg) {
        JsonTokener jt = new JsonTokener(msg);
        JsonObject jo = null;
        try {
            jo = new JsonObject(jt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (jo == null) {
            return;
        }
        String cmdName = jo.getString("cmd");
        if (cmdName == null) {
            return;
        }
        ICmdHandler handler = this.m_handlers.get(cmdName);
        if (handler == null) {
            return;
        }
        this.sendMsg(handler.execute(jo).toString());
    }

    public void addCmdHandler(String cmd, ICmdHandler handler) {
        handler.setDapConsoleProxy(this);
        this.m_handlers.put(cmd, handler);
    }

    public void removeCmdHandler(String cmd) {
        this.m_handlers.remove(cmd).setDapConsoleProxy(null);
    }

    public DapSession getSession(String sessionId) {
        return this.m_emulator.getSession(sessionId);
    }

    public DapConfig getDapConfig() {
        return this.m_emulator.getDapConfig();
    }

    private void initCmdHandlers() {
        this.addCmdHandler("start", new StartCmdHandler());
        this.addCmdHandler("stop", new StopCmdHandler());
        this.addCmdHandler("pause", new PauseCmdHandler());
        this.addCmdHandler("resume", new ResumeCmdHandler());
        this.addCmdHandler("replay", new ReplayCmdHandler());
    }

    private String getSessionStatus(DapSession session) {
        IDapCapture capture = session.getCaptureReplay().getCapture();
        IDapCapture.CaptureState state = capture.state();
        String status = "";
        if (IDapCapture.CaptureState.paused == state) {
            status = "RECORD_PENDING";
        } else if (IDapCapture.CaptureState.resumed == state) {
            status = "RECORDING";
        } else if (IDapCapture.CaptureState.started == state) {
            status = "RECORDING";
        } else if (IDapCapture.CaptureState.stoped == state) {
            status = "READY";
        }
        return status;
    }

    public static abstract class DapConsoleProxyCmdCliHandler
    extends DapConsoleProxyCmdHandler {
        protected abstract String genCmdLine(JsonObject var1, DapSession var2);

        @Override
        protected void handleCmd(JsonObject jo, DapSession session) {
            String cmdLine = this.genCmdLine(jo, session);
            for (IDapConsoleHandler iDapConsoleHandler : this.getProxy().getDapConfig().getConsoleHandlers()) {
                this.executeCmdLine(cmdLine, iDapConsoleHandler);
            }
        }

        protected void executeCmdLine(String cmdLine, IDapConsoleHandler h) {
            h.handle(cmdLine);
        }
    }

    public static abstract class DapConsoleProxyCmdHandler
    implements ICmdHandler {
        private DapConsoleProxy m_proxy;

        @Override
        public void setDapConsoleProxy(DapConsoleProxy proxy) {
            this.m_proxy = proxy;
        }

        protected DapConsoleProxy getProxy() {
            return this.m_proxy;
        }

        @Override
        public JsonObject execute(JsonObject jo) {
            String sessionId = jo.getString("sessionid");
            if (sessionId == null) {
                return this.buildResp(false, sessionId, "Invalid sessionid.");
            }
            DapSession session = this.m_proxy.getSession(sessionId);
            if (session == null) {
                return this.buildResp(false, sessionId, "Invalid sessionid.");
            }
            session.getCurrentView().setupCtx();
            this.handleCmd(jo, session);
            return this.buildResp(true, sessionId, null);
        }

        protected abstract void handleCmd(JsonObject var1, DapSession var2);

        private JsonObject buildResp(boolean isSuccess, String sessionId, String errMsg) {
            DapSession session;
            JsonObject jo = new JsonObject();
            jo.put("cmd", (Object)"response");
            jo.put("result", isSuccess ? 0 : 1);
            jo.put("sessionid", (Object)sessionId);
            if (sessionId != null && (session = this.m_proxy.getSession(sessionId)) != null) {
                jo.put("status", (Object)this.m_proxy.getSessionStatus(session));
            }
            JsonArray errs = new JsonArray();
            if (!isSuccess) {
                errs.put((Object)errMsg);
            }
            jo.accumulate("errormsg", (Object)errs);
            return jo;
        }
    }

    public static interface ICmdHandler {
        public JsonObject execute(JsonObject var1);

        public void setDapConsoleProxy(DapConsoleProxy var1);
    }

    private class PauseCmdHandler
    extends DapConsoleProxyCmdCliHandler {
        private PauseCmdHandler() {
        }

        @Override
        protected String genCmdLine(JsonObject jo, DapSession session) {
            return "CAPTURE_PAUSE";
        }
    }

    private class ReplayCmdHandler
    extends DapConsoleProxyCmdCliHandler {
        private ReplayCmdHandler() {
        }

        @Override
        protected String genCmdLine(JsonObject jo, DapSession session) {
            String cmdLine = "REPLAY";
            if (jo.has("mode")) {
                String mode = jo.getString("mode");
                if ("FAST".equals(mode)) {
                    cmdLine = "FAST_REPLAY";
                } else if ("NORMAL".equals(mode)) {
                    cmdLine = "REPLAY";
                } else if ("SLOW".equals(mode)) {
                    cmdLine = "SLOW_REPLAY";
                }
            }
            return cmdLine;
        }
    }

    private class ResumeCmdHandler
    extends DapConsoleProxyCmdCliHandler {
        private ResumeCmdHandler() {
        }

        @Override
        protected String genCmdLine(JsonObject jo, DapSession session) {
            return "CAPTURE_RESUME";
        }
    }

    private class StartCmdHandler
    extends DapConsoleProxyCmdCliHandler {
        private StartCmdHandler() {
        }

        @Override
        protected String genCmdLine(JsonObject jo, DapSession session) {
            String grpName;
            String cmdLine = "CAPTURE_START";
            if (jo.has("groupname") && (grpName = jo.getString("groupname")) != null) {
                cmdLine = String.valueOf(cmdLine) + " " + grpName;
            }
            return cmdLine;
        }
    }

    private class StopCmdHandler
    extends DapConsoleProxyCmdCliHandler {
        private StopCmdHandler() {
        }

        @Override
        protected String genCmdLine(JsonObject jo, DapSession session) {
            return "CAPTURE_STOP";
        }
    }
}

